/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.thread;

import java.lang.reflect.Proxy;
import javax.servlet.http.HttpServletRequest;
import net.paoding.rose.web.impl.module.ControllerRef;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.thread.Engine;
import net.paoding.rose.web.impl.thread.Rose;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControllerEngine
implements Engine {
    private static Log logger = LogFactory.getLog(ControllerEngine.class);
    private final Module module;
    private final Object controller;
    private final boolean proxiedController;
    private final Class<?> controllerClass;
    private final String viewPrefix;

    public ControllerEngine(Module module, ControllerRef controllerRef) {
        this.module = module;
        this.controller = controllerRef.getControllerObject();
        this.controllerClass = controllerRef.getControllerClass();
        this.viewPrefix = controllerRef.getControllerName() + "-";
        this.proxiedController = Proxy.isProxyClass(this.controller.getClass());
        if (this.proxiedController && logger.isDebugEnabled()) {
            logger.debug((Object)("it's a proxied controller: " + this.controllerClass.getName()));
        }
    }

    public Module getModule() {
        return this.module;
    }

    public String getViewPrefix() {
        return this.viewPrefix;
    }

    public Object getController() {
        return this.controller;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public boolean isProxiedController() {
        return this.proxiedController;
    }

    @Override
    public int isAccepted(HttpServletRequest rose) {
        return 1;
    }

    @Override
    public Object execute(Rose rose) throws Throwable {
        return rose.doNext();
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return this.getControllerClass().getName();
    }
}

