/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.thread;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.RoseVersion;
import net.paoding.rose.util.RoseStringUtil;
import net.paoding.rose.web.ControllerInterceptor;
import net.paoding.rose.web.InterceptorDelegate;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.InvocationChain;
import net.paoding.rose.web.ParamValidator;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.annotation.HttpFeatures;
import net.paoding.rose.web.annotation.IfParamExists;
import net.paoding.rose.web.annotation.Intercepted;
import net.paoding.rose.web.annotation.Return;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.thread.Engine;
import net.paoding.rose.web.impl.thread.InvocationBean;
import net.paoding.rose.web.impl.thread.Rose;
import net.paoding.rose.web.impl.validation.ParameterBindingResult;
import net.paoding.rose.web.paramresolver.MethodParameterResolver;
import net.paoding.rose.web.paramresolver.ParamMetaData;
import net.paoding.rose.web.paramresolver.ParamResolver;
import net.paoding.rose.web.paramresolver.ParameterNameDiscovererImpl;
import net.paoding.rose.web.paramresolver.ResolverFactoryImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.SpringVersion;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

public final class ActionEngine
implements Engine {
    private static final Log logger = LogFactory.getLog(ActionEngine.class);
    private final Module module;
    private final Class<?> controllerClass;
    private final Object controller;
    private final Method method;
    private final HttpFeatures httpFeatures;
    private final InterceptorDelegate[] interceptors;
    private final ParamValidator[] validators;
    private final ParamExistenceChecker[] paramExistenceChecker;
    private final MethodParameterResolver methodParameterResolver;
    private transient String toStringCache;

    public ActionEngine(Module module, Class<?> controllerClass, Object controller, Method method) {
        this.module = module;
        this.controllerClass = controllerClass;
        this.controller = controller;
        this.method = method;
        this.interceptors = this.compileInterceptors();
        this.methodParameterResolver = this.compileParamResolvers();
        this.validators = this.compileValidators();
        this.paramExistenceChecker = this.compileParamExistenceChecker();
        HttpFeatures httpFeatures = method.getAnnotation(HttpFeatures.class);
        if (httpFeatures == null) {
            httpFeatures = this.controllerClass.getAnnotation(HttpFeatures.class);
        }
        this.httpFeatures = httpFeatures;
    }

    public InterceptorDelegate[] getRegisteredInterceptors() {
        return this.interceptors;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public Object getController() {
        return this.controller;
    }

    public Method getMethod() {
        return this.method;
    }

    public String[] getParameterNames() {
        return this.methodParameterResolver.getParameterNames();
    }

    private MethodParameterResolver compileParamResolvers() {
        ParameterNameDiscovererImpl parameterNameDiscoverer = new ParameterNameDiscovererImpl();
        ResolverFactoryImpl resolverFactory = new ResolverFactoryImpl();
        for (ParamResolver resolver : this.module.getCustomerResolvers()) {
            resolverFactory.addCustomerResolver(resolver);
        }
        return new MethodParameterResolver(this.controllerClass, this.method, parameterNameDiscoverer, resolverFactory);
    }

    private ParamValidator[] compileValidators() {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        List<ParamValidator> validators = this.module.getValidators();
        ParamValidator[] registeredValidators = new ParamValidator[parameterTypes.length];
        block0: for (int i = 0; i < parameterTypes.length; ++i) {
            for (ParamValidator validator : validators) {
                if (!validator.supports(this.methodParameterResolver.getParamMetaDatas()[i])) continue;
                registeredValidators[i] = validator;
                continue block0;
            }
        }
        return registeredValidators;
    }

    private InterceptorDelegate[] compileInterceptors() {
        List<InterceptorDelegate> interceptors = this.module.getInterceptors();
        ArrayList<InterceptorDelegate> registeredInterceptors = new ArrayList<InterceptorDelegate>(interceptors.size());
        for (InterceptorDelegate interceptor : interceptors) {
            ControllerInterceptor most = InterceptorDelegate.getMostInnerInterceptor(interceptor);
            if (!most.getClass().getName().startsWith("net.paoding.rose.web")) {
                Intercepted intercepted = this.method.getAnnotation(Intercepted.class);
                if (intercepted == null) {
                    intercepted = this.controllerClass.getAnnotation(Intercepted.class);
                }
                if (intercepted != null) {
                    if (RoseStringUtil.matches(intercepted.deny(), interceptor.getName())) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("action '" + this.controllerClass.getName() + "#" + this.method.getName() + "': remove interceptor by @Intercepted.deny: " + most.getClass().getName()));
                        continue;
                    }
                    if (!RoseStringUtil.matches(intercepted.allow(), interceptor.getName())) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("action '" + this.controllerClass.getName() + "#" + this.method.getName() + "': remove interceptor by @Intercepted.allow: " + most.getClass().getName()));
                        continue;
                    }
                }
            }
            if (interceptor.isForAction(this.controllerClass, this.method)) {
                registeredInterceptors.add(interceptor);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("action '" + this.controllerClass.getName() + "#" + this.method.getName() + "': remove interceptor by interceptor.isForAction: " + most.getClass().getName()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("interceptors of " + this.controllerClass.getName() + "#" + this.method.getName() + "=(" + registeredInterceptors.size() + "/" + interceptors.size() + ")" + registeredInterceptors));
        }
        return registeredInterceptors.toArray(new InterceptorDelegate[registeredInterceptors.size()]);
    }

    private ParamExistenceChecker[] compileParamExistenceChecker() {
        IfParamExists ifParamExists = this.method.getAnnotation(IfParamExists.class);
        if (ifParamExists == null || ifParamExists.value().trim().length() == 0) {
            return new ParamExistenceChecker[0];
        }
        ArrayList<ParamExistenceChecker> checkers = new ArrayList<ParamExistenceChecker>();
        String value = ifParamExists.value();
        String[] terms = StringUtils.split((String)value, (String)"&");
        Assert.isTrue((terms.length >= 1 ? 1 : 0) != 0);
        for (final String term : terms) {
            int index = term.indexOf(61);
            if (index == -1) {
                checkers.add(new ParamExistenceChecker(){
                    final String paramName;
                    {
                        this.paramName = term.trim();
                    }

                    @Override
                    public int check(Map<String, String[]> params) {
                        Object[] paramValues = params.get(this.paramName);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(this.toString() + " is checking param:" + this.paramName + "=" + Arrays.toString(paramValues)));
                        }
                        if (paramValues != null && paramValues.length > 0) {
                            return 10;
                        }
                        return -1;
                    }
                });
                continue;
            }
            final String paramName = term.substring(0, index).trim();
            final String expected = term.substring(index + 1).trim();
            if (expected.startsWith(":")) {
                Pattern tmpPattern = null;
                try {
                    tmpPattern = Pattern.compile(expected.substring(1));
                }
                catch (PatternSyntaxException e) {
                    logger.error((Object)("@IfParamExists pattern error, " + this.controllerClass.getName() + "#" + this.method.getName()), (Throwable)e);
                }
                final Pattern pattern = tmpPattern;
                checkers.add(new ParamExistenceChecker(){

                    @Override
                    public int check(Map<String, String[]> params) {
                        Object[] paramValues = params.get(paramName);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(this.toString() + " is checking param:" + paramName + "=" + Arrays.toString(paramValues) + ", pattern=" + pattern.pattern()));
                        }
                        if (paramValues == null) {
                            return -1;
                        }
                        for (String string : paramValues) {
                            if (pattern == null || !pattern.matcher(string).matches()) continue;
                            return 12;
                        }
                        return -1;
                    }
                });
                continue;
            }
            checkers.add(new ParamExistenceChecker(){

                @Override
                public int check(Map<String, String[]> params) {
                    Object[] paramValues = params.get(paramName);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(this.toString() + " is checking param:" + paramName + "=" + Arrays.toString(paramValues) + ", expected=" + expected));
                    }
                    if (paramValues == null) {
                        return -1;
                    }
                    for (String string : paramValues) {
                        if (!expected.equals(string)) continue;
                        return 13;
                    }
                    return -1;
                }
            });
        }
        return checkers.toArray(new ParamExistenceChecker[0]);
    }

    @Override
    public int isAccepted(HttpServletRequest request) {
        if (this.paramExistenceChecker.length == 0) {
            return 1;
        }
        int total = 0;
        Map<String, String[]> params = this.resolveQueryString(request.getQueryString());
        for (ParamExistenceChecker checker : this.paramExistenceChecker) {
            int c = checker.check(params);
            if (c == -1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Accepted check not passed by " + checker.toString()));
                }
                return -1;
            }
            total += c;
        }
        return total;
    }

    private Map<String, String[]> resolveQueryString(String queryString) {
        Map<String, String[]> params;
        if (queryString == null || queryString.length() == 0) {
            params = Collections.emptyMap();
        } else {
            String[] kvs;
            params = new HashMap<String, String[]>();
            for (String kv : kvs = queryString.split("&")) {
                String[] pair = kv.split("=");
                if (pair.length == 2) {
                    this.mapPut(params, pair[0], pair[1]);
                    continue;
                }
                if (pair.length == 1) {
                    this.mapPut(params, pair[0], "");
                    continue;
                }
                logger.error((Object)("Illegal queryString:" + queryString));
            }
        }
        return params;
    }

    private void mapPut(Map<String, String[]> map, String key, String value) {
        String[] values = map.get(key);
        if (values == null) {
            values = new String[]{value};
        } else {
            values = Arrays.copyOf(values, values.length + 1);
            values[values.length - 1] = value;
        }
        map.put(key, values);
    }

    @Override
    public Object execute(Rose rose) throws Throwable {
        try {
            return this.innerExecute(rose);
        }
        catch (Throwable local) {
            throw this.createException(rose, local);
        }
    }

    protected Object innerExecute(Rose rose) throws Throwable {
        int i;
        InvocationBean inv = rose.getInvocation();
        ParameterBindingResult paramBindingResult = new ParameterBindingResult(inv);
        String paramBindingResultName = BindingResult.MODEL_KEY_PREFIX + paramBindingResult.getObjectName();
        inv.addModel(paramBindingResultName, (Object)paramBindingResult);
        Object[] methodParameters = this.methodParameterResolver.resolve(inv, paramBindingResult);
        inv.setMethodParameters(methodParameters);
        String[] parameterNames = this.methodParameterResolver.getParameterNames();
        Object instruction = null;
        ParamMetaData[] metaDatas = this.methodParameterResolver.getParamMetaDatas();
        for (i = 0; i < this.validators.length; ++i) {
            if (this.validators[i] == null || methodParameters[i] instanceof Errors) continue;
            BindingResult errors = inv.getBindingResult(parameterNames[i]);
            instruction = this.validators[i].validate(metaDatas[i], inv, methodParameters[i], (Errors)errors);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("do validate [" + this.validators[i].getClass().getName() + "] and return '" + instruction + "'"));
            }
            if (instruction == null || instruction instanceof Boolean || instruction instanceof String && ((String)instruction).length() == 0) continue;
            return instruction;
        }
        for (i = 0; i < parameterNames.length; ++i) {
            if (parameterNames[i] == null || methodParameters[i] == null || inv.getModel().get(parameterNames[i]) == methodParameters[i]) continue;
            inv.addModel(parameterNames[i], methodParameters[i]);
        }
        return new InvocationChainImpl(rose).doNext();
    }

    private Exception createException(Rose rose, Throwable exception) {
        RequestPath requestPath = rose.getInvocation().getRequestPath();
        StringBuilder sb = new StringBuilder(1024);
        sb.append("[Rose-").append(RoseVersion.getVersion()).append("@Spring-").append(SpringVersion.getVersion());
        sb.append("]Error happended: ").append((Object)requestPath.getMethod());
        sb.append(" ").append(requestPath.getUri());
        sb.append("->");
        sb.append(this).append(" params=");
        sb.append(Arrays.toString(rose.getInvocation().getMethodParameters()));
        InvocationTargetException servletException = new InvocationTargetException(exception, sb.toString());
        return servletException;
    }

    private void applyHttpFeatures(Invocation inv) throws UnsupportedEncodingException {
        HttpServletResponse response = inv.getResponse();
        if (StringUtils.isNotBlank((String)this.httpFeatures.charset())) {
            response.setCharacterEncoding(this.httpFeatures.charset());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set response.characterEncoding by HttpFeatures:" + this.httpFeatures.charset()));
            }
        }
        if (StringUtils.isNotBlank((String)this.httpFeatures.contentType())) {
            String contentType = this.httpFeatures.contentType();
            if (contentType.equals("json")) {
                contentType = "application/json";
            } else if (contentType.equals("xml")) {
                contentType = "text/xml";
            } else if (contentType.equals("html")) {
                contentType = "text/html";
            } else if (contentType.equals("plain") || contentType.equals("text")) {
                contentType = "text/plain";
            }
            response.setContentType(contentType);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set response.contentType by HttpFeatures:" + response.getContentType()));
            }
        }
    }

    public String toString() {
        if (this.toStringCache == null) {
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            String appPackageName = this.controllerClass.getPackage().getName();
            if (appPackageName.indexOf(46) != -1) {
                appPackageName = appPackageName.substring(0, appPackageName.lastIndexOf(46));
            }
            String methodParamNames = "";
            for (int i = 0; i < parameterTypes.length; ++i) {
                methodParamNames = methodParamNames.length() == 0 ? this.showSimpleName(parameterTypes[i], appPackageName) : methodParamNames + ", " + this.showSimpleName(parameterTypes[i], appPackageName);
            }
            this.toStringCache = "" + this.showSimpleName(this.method.getReturnType(), appPackageName) + " " + this.method.getName() + "(" + methodParamNames + ")";
        }
        return this.toStringCache;
    }

    private String showSimpleName(Class<?> parameterType, String appPackageName) {
        if (parameterType.getName().startsWith("net.paoding") || parameterType.getName().startsWith("java.lang") || parameterType.getName().startsWith("java.util") || parameterType.getName().startsWith(appPackageName)) {
            return parameterType.getSimpleName();
        }
        return parameterType.getName();
    }

    @Override
    public void destroy() {
    }

    private class InvocationChainImpl
    implements InvocationChain {
        private final boolean debugEnabled = ActionEngine.access$000().isDebugEnabled();
        private int index = -1;
        private final Rose rose;
        private Object instruction;

        public InvocationChainImpl(Rose rose) {
            this.rose = rose;
        }

        @Override
        public Object doNext() throws Exception {
            if (++this.index < ActionEngine.this.interceptors.length) {
                InterceptorDelegate interceptor = ActionEngine.this.interceptors[this.index];
                this.rose.addAfterCompletion(interceptor);
                Object instruction = interceptor.roundInvocation(this.rose.getInvocation(), this);
                if (this.debugEnabled) {
                    logger.debug((Object)("interceptor[" + interceptor.getName() + "] do round and return '" + instruction + "'"));
                }
                if (instruction != null) {
                    this.instruction = instruction;
                }
                return this.instruction;
            }
            if (this.index == ActionEngine.this.interceptors.length) {
                Return returnAnnotation;
                if (ActionEngine.this.httpFeatures != null) {
                    ActionEngine.this.applyHttpFeatures(this.rose.getInvocation());
                }
                this.instruction = ActionEngine.this.method.invoke(ActionEngine.this.controller, this.rose.getInvocation().getMethodParameters());
                if (this.instruction == null && (returnAnnotation = ActionEngine.this.method.getAnnotation(Return.class)) != null) {
                    this.instruction = returnAnnotation.value();
                }
                return this.instruction;
            }
            throw new IndexOutOfBoundsException("don't call twice 'chain.doNext()' in one intercpetor; index=" + this.index + "; interceptors.length=" + ActionEngine.this.interceptors.length);
        }
    }

    private static interface ParamExistenceChecker {
        public int check(Map<String, String[]> var1);
    }
}

