/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.module;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import net.paoding.rose.RoseConstants;
import net.paoding.rose.scanner.ModuleResource;
import net.paoding.rose.util.RoseStringUtil;
import net.paoding.rose.util.SpringUtils;
import net.paoding.rose.web.ControllerErrorHandler;
import net.paoding.rose.web.ControllerInterceptor;
import net.paoding.rose.web.InterceptorDelegate;
import net.paoding.rose.web.OncePerRequestInterceptorDelegate;
import net.paoding.rose.web.ParamValidator;
import net.paoding.rose.web.advancedinterceptor.Ordered;
import net.paoding.rose.web.annotation.Ignored;
import net.paoding.rose.web.annotation.Interceptor;
import net.paoding.rose.web.annotation.NotForSubModules;
import net.paoding.rose.web.annotation.Path;
import net.paoding.rose.web.impl.module.ErrorHandlerDispatcher;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.module.ModuleAppContext;
import net.paoding.rose.web.impl.module.ModuleImpl;
import net.paoding.rose.web.impl.module.ModulesBuilder;
import net.paoding.rose.web.paramresolver.ParamResolver;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ModulesBuilderImpl
implements ModulesBuilder {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String AUTO_BEAN_NAME_PREFIX = "ModuleBuilder.";

    @Override
    public List<Module> build(List<ModuleResource> moduleResources, WebApplicationContext rootContext) throws Exception {
        moduleResources = new ArrayList<ModuleResource>(moduleResources);
        Collections.sort(moduleResources);
        ArrayList<Module> modules = new ArrayList<Module>(moduleResources.size());
        HashMap<ModuleResource, ModuleImpl> modulesAsMap = new HashMap<ModuleResource, ModuleImpl>();
        for (ModuleResource moduleResource : moduleResources) {
            ControllerErrorHandler errorHandler;
            Module parentModule = moduleResource.getParent() == null ? null : (Module)modulesAsMap.get(moduleResource.getParent());
            WebApplicationContext parentContext = parentModule == null ? rootContext : parentModule.getApplicationContext();
            String namespace = "context@controllers" + moduleResource.getRelativePath().replace('/', '.');
            ServletContext servletContext = parentContext == null ? null : parentContext.getServletContext();
            ModuleAppContext moduleContext = ModuleAppContext.createModuleContext(parentContext, moduleResource.getContextResources(), moduleResource.getMessageBasenames(), moduleResource.getModuleUrl().toString(), namespace);
            this.registerBeanDefinitions(moduleContext, moduleResource.getModuleClasses());
            ModuleImpl module = new ModuleImpl(parentModule, moduleResource.getModuleUrl(), moduleResource.getMappingPath(), moduleResource.getRelativePath(), (WebApplicationContext)moduleContext);
            modulesAsMap.put(moduleResource, module);
            if (servletContext != null) {
                String contextAttrKey = WebApplicationContext.class.getName() + "@" + moduleResource.getModuleUrl();
                servletContext.setAttribute(contextAttrKey, (Object)moduleContext);
            }
            List<ParamResolver> customerResolvers = this.findContextResolvers(moduleContext);
            module.setCustomerResolvers(customerResolvers);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("module '" + module.getMappingPath() + "': apply resolvers " + customerResolvers));
            }
            List<InterceptorDelegate> interceptors = this.findInterceptors(moduleContext);
            Iterator<InterceptorDelegate> iter = interceptors.iterator();
            while (iter.hasNext()) {
                InterceptorDelegate interceptor = iter.next();
                ControllerInterceptor most = InterceptorDelegate.getMostInnerInterceptor(interceptor);
                if (most.getClass().getName().startsWith("net.paoding.rose.web")) continue;
                if (moduleResource.getInterceptedDeny() != null && RoseStringUtil.matches(moduleResource.getInterceptedDeny(), interceptor.getName())) {
                    iter.remove();
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("module '" + module.getMappingPath() + "': remove interceptor by rose.properties: " + most.getClass().getName()));
                    continue;
                }
                if (moduleResource.getInterceptedAllow() == null || RoseStringUtil.matches(moduleResource.getInterceptedAllow(), interceptor.getName())) continue;
                iter.remove();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("module '" + module.getMappingPath() + "': remove interceptor by rose.properties: " + most.getClass().getName()));
            }
            module.setControllerInterceptors(interceptors);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("module '" + module.getMappingPath() + "': apply intercetpors " + interceptors));
            }
            List<ParamValidator> validators = this.findContextValidators(moduleContext);
            module.setValidators(validators);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("module '" + module.getMappingPath() + "': apply global validators " + validators));
            }
            if ((errorHandler = this.getContextErrorHandler(moduleContext)) != null) {
                if (Proxy.isProxyClass(errorHandler.getClass())) {
                    module.setErrorHandler(errorHandler);
                } else {
                    ErrorHandlerDispatcher dispatcher = new ErrorHandlerDispatcher(errorHandler);
                    module.setErrorHandler(dispatcher);
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("set errorHandler: " + module.getMappingPath() + "  " + errorHandler));
                }
            }
            ConfigurableListableBeanFactory beanFactory = moduleContext.getBeanFactory();
            for (String beanName : beanFactory.getBeanDefinitionNames()) {
                this.checkController(moduleContext, beanName, module);
            }
            modules.add(module);
        }
        return modules;
    }

    private void throwExceptionIfDuplicatedNames(List<InterceptorDelegate> interceptors) {
        for (int i = 0; i < interceptors.size(); ++i) {
            InterceptorDelegate interceptor = interceptors.get(i);
            for (int j = i + 1; j < interceptors.size(); ++j) {
                InterceptorDelegate position = interceptors.get(j);
                if (!position.getName().equals(interceptor.getName())) continue;
                ControllerInterceptor duplicated1 = InterceptorDelegate.getMostInnerInterceptor(position);
                ControllerInterceptor duplicated2 = InterceptorDelegate.getMostInnerInterceptor(interceptor);
                throw new IllegalArgumentException("duplicated interceptor name for these two interceptors: '" + duplicated1.getClass() + "' and '" + duplicated2.getClass() + "'");
            }
        }
    }

    private boolean checkController(XmlWebApplicationContext context, String beanName, ModuleImpl module) throws IllegalAccessException {
        AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)context.getBeanFactory().getBeanDefinition(beanName);
        String beanClassName = beanDefinition.getBeanClassName();
        String controllerSuffix = null;
        for (String suffix : RoseConstants.CONTROLLER_SUFFIXES) {
            if (beanClassName.length() <= suffix.length() || !beanClassName.endsWith(suffix) || suffix.length() == 1 && Character.isUpperCase(beanClassName.charAt(beanClassName.length() - suffix.length() - 1))) continue;
            controllerSuffix = suffix;
            break;
        }
        if (controllerSuffix == null) {
            Class beanClass;
            if (beanDefinition.hasBeanClass() && (beanClass = beanDefinition.getBeanClass()).isAnnotationPresent(Path.class)) {
                throw new IllegalArgumentException("@" + Path.class.getSimpleName() + " is only allowed in Resource/Controller, " + "is it a Resource/Controller? wrong spelling? : " + beanClassName);
            }
            if (beanClassName.endsWith("Controler") || beanClassName.endsWith("Controllor") || beanClassName.endsWith("Resouce") || beanClassName.endsWith("Resorce")) {
                this.logger.error((Object)"", (Throwable)new IllegalArgumentException("invalid class name end\uff0c wrong spelling? : " + beanClassName));
            }
            return false;
        }
        Object[] controllerPaths = null;
        if (!beanDefinition.hasBeanClass()) {
            try {
                beanDefinition.resolveBeanClass(Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new CannotLoadBeanClassException("", beanName, beanDefinition.getBeanClassName(), e);
            }
        }
        Class clazz = beanDefinition.getBeanClass();
        String controllerName = StringUtils.removeEnd((String)ClassUtils.getShortNameAsProperty((Class)clazz), controllerSuffix);
        Path reqMappingAnnotation = clazz.getAnnotation(Path.class);
        if (reqMappingAnnotation != null) {
            controllerPaths = reqMappingAnnotation.value();
        }
        if (controllerPaths != null) {
            for (int i = 0; i < controllerPaths.length; ++i) {
                if ("#".equals(controllerPaths[i])) {
                    controllerPaths[i] = "/" + controllerName;
                } else if (controllerPaths[i].equals("/")) {
                    controllerPaths[i] = "";
                } else if (controllerPaths[i].length() > 0 && controllerPaths[i].charAt(0) != '/') {
                    controllerPaths[i] = "/" + controllerPaths[i];
                }
                if (controllerPaths[i].length() <= 1 || !controllerPaths[i].endsWith("/")) continue;
                if (controllerPaths[i].endsWith("//")) {
                    throw new IllegalArgumentException("invalid path '" + (String)controllerPaths[i] + "' for controller " + beanClassName + ": don't end with more than one '/'");
                }
                controllerPaths[i] = ((String)controllerPaths[i]).substring(0, ((String)controllerPaths[i]).length() - 1);
            }
        } else {
            if (controllerName.equals("index") || controllerName.equals("home") || controllerName.equals("welcome")) {
                throw new IllegalArgumentException("please add @Path(\"\") to " + clazz.getName());
            }
            controllerPaths = new String[]{"/" + controllerName};
        }
        Object controller = context.getBean(beanName);
        module.addController((String[])controllerPaths, clazz, controllerName, controller);
        if (Proxy.isProxyClass(controller.getClass())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("module '" + module.getMappingPath() + "': add controller " + Arrays.toString(controllerPaths) + "= proxy of " + clazz.getName()));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("module '" + module.getMappingPath() + "': add controller " + Arrays.toString(controllerPaths) + "= " + controller.getClass().getName()));
        }
        return true;
    }

    private void registerBeanDefinitions(XmlWebApplicationContext context, List<Class<?>> classes) {
        DefaultListableBeanFactory bf = (DefaultListableBeanFactory)context.getBeanFactory();
        Object[] definedClasses = new String[bf.getBeanDefinitionCount()];
        String[] definitionNames = bf.getBeanDefinitionNames();
        for (int i = 0; i < definedClasses.length; ++i) {
            String name = definitionNames[i];
            definedClasses[i] = bf.getBeanDefinition(name).getBeanClassName();
        }
        for (Class<?> clazz : classes) {
            if (!this.isCandidate(clazz)) continue;
            String clazzName = clazz.getName();
            if (ArrayUtils.contains((Object[])definedClasses, (Object)clazzName)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignores bean definition because it has been exist in context: " + clazz.getName()));
                continue;
            }
            String beanName = null;
            if (StringUtils.isEmpty(beanName) && clazz.isAnnotationPresent(Component.class)) {
                beanName = clazz.getAnnotation(Component.class).value();
            }
            if (StringUtils.isEmpty(beanName) && clazz.isAnnotationPresent(Resource.class)) {
                beanName = clazz.getAnnotation(Resource.class).name();
            }
            if (StringUtils.isEmpty(beanName) && clazz.isAnnotationPresent(Service.class)) {
                beanName = clazz.getAnnotation(Service.class).value();
            }
            if (StringUtils.isEmpty(beanName)) {
                beanName = AUTO_BEAN_NAME_PREFIX + clazz.getName();
            }
            bf.registerBeanDefinition(beanName, (BeanDefinition)new AnnotatedGenericBeanDefinition(clazz));
        }
    }

    private boolean isCandidate(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Ignored.class)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Ignores bean definition because it's present by @Ignored : " + clazz.getName()));
            }
            return false;
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Ignores bean definition because it's not a public class: " + clazz.getName()));
            }
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Ignores bean definition because it's a abstract class: " + clazz.getName()));
            }
            return false;
        }
        if (clazz.getDeclaringClass() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Ignores bean definition because it's a inner class: " + clazz.getName()));
            }
            return false;
        }
        return true;
    }

    private ControllerErrorHandler getContextErrorHandler(XmlWebApplicationContext context) {
        ControllerErrorHandler errorHandler = null;
        String[] names = context.getBeanNamesForType(ControllerErrorHandler.class);
        for (int i = 0; errorHandler == null && i < names.length; ++i) {
            errorHandler = (ControllerErrorHandler)context.getBean(names[i]);
            Class userClass = ClassUtils.getUserClass((Object)errorHandler);
            if (!userClass.isAnnotationPresent(Ignored.class)) continue;
            this.logger.debug((Object)("Ignored controllerErrorHandler: " + errorHandler));
            errorHandler = null;
        }
        return errorHandler;
    }

    private List<ParamResolver> findContextResolvers(XmlWebApplicationContext context) {
        String[] resolverNames = SpringUtils.getBeanNames((ListableBeanFactory)context.getBeanFactory(), ParamResolver.class);
        ArrayList<ParamResolver> resolvers = new ArrayList<ParamResolver>(resolverNames.length);
        for (String beanName : resolverNames) {
            ParamResolver resolver = (ParamResolver)context.getBean(beanName);
            Class userClass = ClassUtils.getUserClass((Object)resolver);
            if (userClass.isAnnotationPresent(Ignored.class)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignored context resolver:" + resolver));
                continue;
            }
            if (userClass.isAnnotationPresent(NotForSubModules.class) && context.getBeanFactory().getBeanDefinition(beanName) == null) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignored context resolver (NotForSubModules):" + resolver));
                continue;
            }
            resolvers.add(resolver);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("context resolver[" + resolver.getClass().getName()));
        }
        return resolvers;
    }

    private List<InterceptorDelegate> findInterceptors(XmlWebApplicationContext context) {
        String[] interceptorNames = SpringUtils.getBeanNames((ListableBeanFactory)context.getBeanFactory(), ControllerInterceptor.class);
        ArrayList<InterceptorDelegate> interceptors = new ArrayList<InterceptorDelegate>(interceptorNames.length);
        for (String beanName : interceptorNames) {
            ControllerInterceptor interceptor = (ControllerInterceptor)context.getBean(beanName);
            Class userClass = ClassUtils.getUserClass((Object)interceptor);
            if (userClass.isAnnotationPresent(Ignored.class)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignored interceptor (Ignored):" + interceptor));
                continue;
            }
            if (userClass.isAnnotationPresent(NotForSubModules.class) && !context.getBeanFactory().containsBeanDefinition(beanName)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignored interceptor (NotForSubModules):" + interceptor));
                continue;
            }
            if (!userClass.getSimpleName().endsWith("Interceptor")) {
                this.logger.error((Object)"", (Throwable)new IllegalArgumentException("Interceptor must be end with 'Interceptor': " + userClass.getName()));
                continue;
            }
            InterceptorBuilder builder = new InterceptorBuilder(interceptor);
            Interceptor annotation = userClass.getAnnotation(Interceptor.class);
            if (annotation != null) {
                builder.oncePerRequest(annotation.oncePerRequest());
            }
            String interceporName = beanName.startsWith(AUTO_BEAN_NAME_PREFIX) ? StringUtils.removeEnd((String)StringUtils.uncapitalize((String)userClass.getSimpleName()), (String)"Interceptor") : StringUtils.removeEnd((String)beanName, (String)"Interceptor");
            String rose = "rose";
            if (interceporName.startsWith("rose") && (interceporName.length() == "rose".length() || Character.isUpperCase(interceporName.charAt("rose".length()))) && !userClass.getName().startsWith("net.paoding.rose.")) {
                throw new IllegalArgumentException("illegal interceptor name '" + interceporName + "' for " + userClass.getName() + ": don't starts with 'rose', it's reserved");
            }
            builder.name(interceporName);
            InterceptorDelegate wrapper = builder.build();
            interceptors.add(wrapper);
            if (!this.logger.isDebugEnabled()) continue;
            int priority = 0;
            if (interceptor instanceof Ordered) {
                priority = ((Ordered)((Object)interceptor)).getPriority();
            }
            this.logger.debug((Object)("recognized interceptor[priority=" + priority + "]: " + wrapper.getName() + "=" + userClass.getName()));
        }
        Collections.sort(interceptors);
        this.throwExceptionIfDuplicatedNames(interceptors);
        return interceptors;
    }

    private List<ParamValidator> findContextValidators(XmlWebApplicationContext context) {
        String[] validatorNames = SpringUtils.getBeanNames((ListableBeanFactory)context.getBeanFactory(), ParamValidator.class);
        ArrayList<ParamValidator> globalValidators = new ArrayList<ParamValidator>(validatorNames.length);
        for (String beanName : validatorNames) {
            ParamValidator validator = (ParamValidator)context.getBean(beanName);
            Class userClass = ClassUtils.getUserClass((Object)validator);
            if (userClass.isAnnotationPresent(Ignored.class)) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignored context validator:" + validator));
                continue;
            }
            if (userClass.isAnnotationPresent(NotForSubModules.class) && context.getBeanFactory().getBeanDefinition(beanName) == null) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignored context validator (NotForSubModules):" + validator));
                continue;
            }
            globalValidators.add(validator);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("add context validator: " + userClass.getName()));
        }
        return globalValidators;
    }

    public static class InterceptorBuilder {
        private boolean oncePerRequest;
        private String name;
        private ControllerInterceptor interceptor;

        public InterceptorBuilder(ControllerInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public InterceptorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InterceptorBuilder oncePerRequest(boolean oncePerRequest) {
            this.oncePerRequest = oncePerRequest;
            return this;
        }

        public InterceptorDelegate build() {
            InterceptorDelegate wrapper;
            ControllerInterceptor interceptor = this.interceptor;
            if (this.oncePerRequest) {
                interceptor = new OncePerRequestInterceptorDelegate(interceptor);
            }
            if (StringUtils.isBlank((String)(wrapper = new InterceptorDelegate(interceptor)).getName())) {
                wrapper.setName(this.name);
            }
            return wrapper;
        }
    }
}

