/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.paoding.rose.web.ControllerErrorHandler;
import net.paoding.rose.web.InterceptorDelegate;
import net.paoding.rose.web.ParamValidator;
import net.paoding.rose.web.impl.module.ControllerRef;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.paramresolver.ParamResolver;
import org.springframework.web.context.WebApplicationContext;

public class ModuleImpl
implements Module {
    private String mappingPath;
    private URL url;
    private String relativePath;
    private Module parent;
    private WebApplicationContext applicationContext;
    private List<ControllerRef> controllers = new ArrayList<ControllerRef>();
    private List<ParamResolver> customerResolvers = Collections.emptyList();
    private List<InterceptorDelegate> interceptors = Collections.emptyList();
    private List<ParamValidator> validators = Collections.emptyList();
    private ControllerErrorHandler errorHandler;

    public ModuleImpl(Module parent, URL url, String mappingPath, String relativePath, WebApplicationContext context) {
        this.parent = parent;
        this.url = url;
        this.mappingPath = mappingPath;
        this.relativePath = relativePath;
        this.applicationContext = context;
    }

    @Override
    public Module getParent() {
        return this.parent;
    }

    @Override
    public String getMappingPath() {
        return this.mappingPath;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public WebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public List<ControllerRef> getControllers() {
        return Collections.unmodifiableList(this.controllers);
    }

    public ModuleImpl addController(String[] mappingPaths, Class<?> controllerClass, String controllerName, Object controllerObject) {
        ControllerRef controller = new ControllerRef(mappingPaths, controllerName, controllerObject, controllerClass);
        this.controllers.add(controller);
        return this;
    }

    public void setCustomerResolvers(List<ParamResolver> resolvers) {
        this.customerResolvers = resolvers;
    }

    @Override
    public List<ParamResolver> getCustomerResolvers() {
        return Collections.unmodifiableList(this.customerResolvers);
    }

    public void setControllerInterceptors(List<InterceptorDelegate> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public List<InterceptorDelegate> getInterceptors() {
        return this.interceptors;
    }

    public void setValidators(List<ParamValidator> validators) {
        this.validators = validators;
    }

    @Override
    public List<ParamValidator> getValidators() {
        return this.validators;
    }

    @Override
    public ControllerErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ControllerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

