/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.module;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ModuleAppContext
extends XmlWebApplicationContext {
    private static final Log logger = LogFactory.getLog(ModuleAppContext.class);
    private List<Resource> contextResources = Collections.emptyList();
    private String[] messageBaseNames = new String[0];

    public static ModuleAppContext createModuleContext(WebApplicationContext parent, List<URL> contextResources, String[] messageBasenames, String uniqueId, String namespace) throws IOException {
        long startTime = System.currentTimeMillis();
        String loadingMsg = "[moduleContext.create] Loading Spring '" + namespace + "' WebApplicationContext";
        logger.info((Object)loadingMsg);
        Assert.notNull((Object)parent);
        ServletContext servletContext = parent.getServletContext();
        Assert.notNull((Object)servletContext);
        ModuleAppContext wac = new ModuleAppContext();
        wac.setParent((ApplicationContext)parent);
        wac.setServletContext(servletContext);
        wac.setContextResources(ModuleAppContext.toResources(contextResources));
        wac.setId(uniqueId);
        wac.setNamespace(namespace);
        wac.setMessageBaseNames(messageBasenames);
        wac.refresh();
        if (logger.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.debug((Object)("[moduleContext.create] Using context class [" + ((Object)((Object)wac)).getClass().getName() + "] for " + namespace + " WebApplicationContext"));
            logger.info((Object)("[moduleContext.create] " + namespace + " WebApplicationContext: initialization completed in " + elapsedTime + " ms"));
        }
        return wac;
    }

    public static List<Resource> toResources(List<URL> contextResources) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (URL url : contextResources) {
            resources.add((Resource)new UrlResource(url));
        }
        return resources;
    }

    public void setContextResources(List<Resource> contextResources) {
        this.contextResources = contextResources;
    }

    protected String[] getDefaultConfigLocations() {
        return null;
    }

    public void setMessageBaseNames(String[] messageBaseNames) {
        if (messageBaseNames == null) {
            messageBaseNames = new String[]{};
        }
        this.messageBaseNames = messageBaseNames;
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        super.loadBeanDefinitions(reader);
        for (Resource resource : this.contextResources) {
            reader.loadBeanDefinitions(resource);
        }
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.prepareBeanFactoryByRose(beanFactory);
        super.prepareBeanFactory(beanFactory);
    }

    protected void prepareBeanFactoryByRose(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)registry);
        if (this.messageBaseNames != null && this.messageBaseNames.length > 0) {
            ModuleAppContext.registerMessageSourceIfNecessary(registry, this.messageBaseNames);
        }
    }

    public static void registerMessageSourceIfNecessary(BeanDefinitionRegistry registry, String[] messageBaseNames) {
        if (!ArrayUtils.contains((Object[])registry.getBeanDefinitionNames(), (Object)"messageSource")) {
            logger.debug((Object)("registerMessageSource  " + ArrayUtils.toString((Object)messageBaseNames)));
            GenericBeanDefinition messageSource = new GenericBeanDefinition();
            messageSource.setBeanClass(ReloadableResourceBundleMessageSource.class);
            MutablePropertyValues propertyValues = new MutablePropertyValues();
            propertyValues.addPropertyValue("useCodeAsDefaultMessage", (Object)true);
            propertyValues.addPropertyValue("defaultEncoding", (Object)"UTF-8");
            propertyValues.addPropertyValue("cacheSeconds", (Object)60);
            propertyValues.addPropertyValue("basenames", (Object)messageBaseNames);
            messageSource.setPropertyValues(propertyValues);
            registry.registerBeanDefinition("messageSource", (BeanDefinition)messageSource);
        }
    }
}

