/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.module;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.paoding.rose.web.ControllerErrorHandler;
import net.paoding.rose.web.Invocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorHandlerDispatcher
implements ControllerErrorHandler {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final int INVOCATION_INDEX = 0;
    private static final int THROWABLE_INDEX = 1;
    private ControllerErrorHandler errorHandler;
    private List<ErrorHandlerDelegate> delegates = new ArrayList<ErrorHandlerDelegate>(8);

    public ErrorHandlerDispatcher(ControllerErrorHandler errorHandler) {
        Method[] methods;
        this.errorHandler = errorHandler;
        for (final Method method : methods = this.errorHandler.getClass().getMethods()) {
            Class<?>[] parameterClasses;
            if (Modifier.isAbstract(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || !method.getName().equals("onError") || (parameterClasses = method.getParameterTypes()).length != 2 || parameterClasses[0] != Invocation.class || !Throwable.class.isAssignableFrom(parameterClasses[1])) continue;
            this.delegates.add(new ErrorHandlerDelegate(){

                @Override
                public Method getMethod() {
                    return method;
                }

                @Override
                public Object onError(Invocation inv, Throwable ex) throws Throwable {
                    Object[] args = new Object[]{inv, ex};
                    try {
                        return method.invoke((Object)ErrorHandlerDispatcher.this.errorHandler, args);
                    }
                    catch (Throwable e) {
                        ErrorHandlerDispatcher.this.logger.error((Object)("error happened when handling error " + ex.getClass() + " at " + ErrorHandlerDispatcher.this.toString()));
                        throw e;
                    }
                }
            });
        }
        Collections.sort(this.delegates, new Comparator<ErrorHandlerDelegate>(){

            @Override
            public int compare(ErrorHandlerDelegate o1, ErrorHandlerDelegate o2) {
                if (o1.getMethod().getParameterTypes()[1].isAssignableFrom(o2.getMethod().getParameterTypes()[1])) {
                    return 1;
                }
                if (o2.getMethod().getParameterTypes()[1].isAssignableFrom(o1.getMethod().getParameterTypes()[1])) {
                    return -1;
                }
                return o1.getMethod().getParameterTypes()[1].getName().compareTo(o2.getMethod().getParameterTypes()[1].getName());
            }
        });
    }

    @Override
    public Object onError(Invocation inv, Throwable ex) throws Throwable {
        for (ErrorHandlerDelegate delegate : this.delegates) {
            if (!delegate.getMethod().getParameterTypes()[1].isAssignableFrom(ex.getClass())) continue;
            return delegate.onError(inv, ex);
        }
        throw new Error("not found errorHandlerMethod for exceptionClass" + ex.getClass().getName(), ex);
    }

    public String toString() {
        return this.errorHandler.toString() + this.delegates.toString();
    }

    static abstract class ErrorHandlerDelegate {
        ErrorHandlerDelegate() {
        }

        abstract Method getMethod();

        abstract Object onError(Invocation var1, Throwable var2) throws Throwable;

        public String toString() {
            return this.getMethod().getParameterTypes()[1].getSimpleName();
        }
    }
}

