/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.module;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.paoding.rose.web.annotation.AsSuperController;
import net.paoding.rose.web.annotation.Ignored;
import net.paoding.rose.web.annotation.ReqMethod;
import net.paoding.rose.web.annotation.rest.Delete;
import net.paoding.rose.web.annotation.rest.Get;
import net.paoding.rose.web.annotation.rest.Head;
import net.paoding.rose.web.annotation.rest.Options;
import net.paoding.rose.web.annotation.rest.Post;
import net.paoding.rose.web.annotation.rest.Put;
import net.paoding.rose.web.annotation.rest.Trace;
import net.paoding.rose.web.impl.module.MethodRef;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;

public class ControllerRef {
    private static Log logger = LogFactory.getLog(ControllerRef.class);
    private String[] mappingPaths;
    private String controllerName;
    private Class<?> controllerClass;
    private Object controllerObject;
    List<MethodRef> actions;

    public ControllerRef(String[] mappingPaths, String controllerName, Object controllerObject, Class<?> controllerClass) {
        this.setMappingPaths(mappingPaths);
        this.setControllerName(controllerName);
        this.setControllerObject(controllerObject);
        this.setControllerClass(controllerClass);
    }

    public MethodRef[] getActions() {
        if (this.actions == null) {
            this.init();
        }
        return this.actions.toArray(new MethodRef[0]);
    }

    private void init() {
        LinkedList<MethodRef> actions = new LinkedList<MethodRef>();
        Class<?> clz = this.controllerClass;
        LinkedList<Method> pastMethods = new LinkedList<Method>();
        do {
            Method[] declaredMethods;
            for (Method method : declaredMethods = clz.getDeclaredMethods()) {
                if (this.quicklyPass(pastMethods, method, this.controllerClass)) continue;
                Map<ReqMethod, String[]> shotcutMappings = this.collectsShotcutMappings(method);
                if (shotcutMappings.size() == 0) {
                    if (this.ignoresCommonMethod(method)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("ignores common methods of controller " + this.controllerClass.getName() + "#" + method.getName()));
                        }
                    } else {
                        if ("get".equals(method.getName()) || "index".equals(method.getName())) {
                            throw new IllegalArgumentException("please add @Get to " + this.controllerClass.getName() + "#" + method.getName());
                        }
                        if ("post".equals(method.getName()) || "delete".equals(method.getName()) || "put".equals(method.getName())) {
                            throw new IllegalArgumentException("please add @" + StringUtils.capitalize((String)method.getName()) + " to " + this.controllerClass.getName() + "#" + method.getName());
                        }
                        shotcutMappings = new HashMap<ReqMethod, String[]>();
                        shotcutMappings.put(ReqMethod.GET, new String[]{"/" + method.getName()});
                        shotcutMappings.put(ReqMethod.POST, new String[]{"/" + method.getName()});
                    }
                }
                if (shotcutMappings.size() <= 0) continue;
                MethodRef methodRef = new MethodRef();
                for (Map.Entry<ReqMethod, String[]> entry : shotcutMappings.entrySet()) {
                    methodRef.addMapping(entry.getKey(), entry.getValue());
                }
                methodRef.setMethod(method);
                actions.add(methodRef);
            }
            for (int i = 0; i < declaredMethods.length; ++i) {
                pastMethods.add(declaredMethods[i]);
            }
        } while ((clz = clz.getSuperclass()) != null && clz.getAnnotation(AsSuperController.class) != null);
        this.actions = actions;
    }

    private Map<ReqMethod, String[]> collectsShotcutMappings(Method method) {
        Annotation[] annotations;
        HashMap<ReqMethod, String[]> restMethods = new HashMap<ReqMethod, String[]>();
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (annotation instanceof Delete) {
                restMethods.put(ReqMethod.DELETE, ((Delete)annotation).value());
                continue;
            }
            if (annotation instanceof Get) {
                restMethods.put(ReqMethod.GET, ((Get)annotation).value());
                continue;
            }
            if (annotation instanceof Head) {
                restMethods.put(ReqMethod.HEAD, ((Head)annotation).value());
                continue;
            }
            if (annotation instanceof Options) {
                restMethods.put(ReqMethod.OPTIONS, ((Options)annotation).value());
                continue;
            }
            if (annotation instanceof Post) {
                restMethods.put(ReqMethod.POST, ((Post)annotation).value());
                continue;
            }
            if (annotation instanceof Put) {
                restMethods.put(ReqMethod.PUT, ((Put)annotation).value());
                continue;
            }
            if (!(annotation instanceof Trace)) continue;
            restMethods.put(ReqMethod.TRACE, ((Trace)annotation).value());
        }
        for (String[] paths : restMethods.values()) {
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].equals("/")) {
                    paths[i] = "";
                } else if (paths[i].length() > 0 && paths[i].charAt(0) != '/') {
                    paths[i] = "/" + paths[i];
                }
                if (paths[i].length() <= 1 || !paths[i].endsWith("/")) continue;
                if (paths[i].endsWith("//")) {
                    throw new IllegalArgumentException("invalid path '" + paths[i] + "' for method " + method.getDeclaringClass().getName() + "#" + method.getName() + ": don't end with more than one '/'");
                }
                paths[i] = paths[i].substring(0, paths[i].length() - 1);
            }
        }
        return restMethods;
    }

    private boolean quicklyPass(List<Method> pastMethods, Method method, Class<?> controllerClass) {
        if (!Modifier.isPublic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(Ignored.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ignores method of controller " + controllerClass.getName() + "." + method.getName() + "  [@ignored?not public?abstract?static?]"));
            }
            return true;
        }
        for (Method past : pastMethods) {
            if (!past.getName().equals(method.getName()) || !Arrays.equals(past.getParameterTypes(), method.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean ignoresCommonMethod(Method method) {
        if (ClassUtils.hasMethod(Object.class, (String)method.getName(), (Class[])method.getParameterTypes())) {
            return true;
        }
        String name = method.getName();
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt("get".length())) && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && null == method.getAnnotation(Get.class)) {
            return true;
        }
        if (name.startsWith("is") && name.length() > 3 && Character.isUpperCase(name.charAt("is".length())) && method.getParameterTypes().length == 0 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class) && null == method.getAnnotation(Get.class)) {
            return true;
        }
        return name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt("set".length())) && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && null == method.getAnnotation(Post.class);
    }

    public void setMappingPaths(String[] mappingPaths) {
        this.mappingPaths = mappingPaths;
    }

    public String[] getMappingPaths() {
        return this.mappingPaths;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(Class<?> controllerClass) {
        this.controllerClass = controllerClass;
    }

    public Object getControllerObject() {
        return this.controllerObject;
    }

    public void setControllerObject(Object controllerObject) {
        this.controllerObject = controllerObject;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public void setControllerName(String controllerName) {
        this.controllerName = controllerName;
    }

    public String toString() {
        return this.controllerClass.getName();
    }
}

