/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.mapping;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.paoding.rose.util.PrinteHelper;
import net.paoding.rose.web.annotation.ReqMethod;
import net.paoding.rose.web.impl.mapping.Mapping;
import net.paoding.rose.web.impl.mapping.MappingFactory;
import net.paoding.rose.web.impl.mapping.MappingNode;
import net.paoding.rose.web.impl.module.ControllerRef;
import net.paoding.rose.web.impl.module.MethodRef;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.thread.ActionEngine;
import net.paoding.rose.web.impl.thread.ControllerEngine;
import net.paoding.rose.web.impl.thread.LinkedEngine;
import net.paoding.rose.web.impl.thread.ModuleEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeBuilder {
    protected static final Log logger = LogFactory.getLog(TreeBuilder.class);

    public void create(MappingNode tree, List<Module> modules) {
        this.addRoot(tree, modules);
        this.check(tree, tree, "");
    }

    private void addRoot(MappingNode rootNode, List<Module> modules) {
        for (Module module : modules) {
            this.addModule(rootNode, module);
        }
    }

    private void addModule(MappingNode rootNode, Module module) {
        List<Mapping> terms = MappingFactory.parse(module.getMappingPath());
        LinkedEngine rootEngine = rootNode.getMiddleEngines().getEngines(ReqMethod.GET)[0];
        MappingNode parent = rootNode;
        for (Mapping mapping : terms) {
            if (mapping.getDefinition().length() == 0) continue;
            MappingNode temp = parent.getChild(mapping.getDefinition());
            if (temp == null) {
                temp = new MappingNode(mapping);
                parent.linkAsChild(temp);
            }
            parent = temp;
        }
        LinkedEngine moduleEngine = new LinkedEngine(rootEngine, new ModuleEngine(module), parent);
        parent.getMiddleEngines().addEngine(ReqMethod.ALL, moduleEngine);
        List<ControllerRef> controllers = module.getControllers();
        for (ControllerRef controller : controllers) {
            this.addController(module, parent, moduleEngine, controller);
        }
    }

    private void addController(Module module, MappingNode moduleNode, LinkedEngine moduleEngine, ControllerRef controller) {
        ControllerEngine engine = new ControllerEngine(module, controller);
        HashSet<String> mappingPaths = new HashSet<String>(Arrays.asList(controller.getMappingPaths()));
        for (String mappingPath : mappingPaths) {
            MethodRef[] actions;
            List<Mapping> mappings = MappingFactory.parse(mappingPath);
            MappingNode target = moduleNode;
            for (Mapping mapping : mappings) {
                if (mapping.getDefinition().length() == 0) continue;
                MappingNode temp = target.getChild(mapping.getDefinition());
                if (temp == null) {
                    temp = new MappingNode(mapping);
                    target.linkAsChild(temp);
                }
                target = temp;
            }
            LinkedEngine controllerEngine = new LinkedEngine(moduleEngine, engine, target);
            target.getMiddleEngines().addEngine(ReqMethod.ALL, controllerEngine);
            for (MethodRef action : actions = controller.getActions()) {
                this.addAction(module, controller, action, target, controllerEngine);
            }
        }
    }

    private void addAction(Module module, ControllerRef controller, MethodRef action, MappingNode controllerNode, LinkedEngine controllerEngine) {
        Map<String, Set<ReqMethod>> mappingPaths = action.getMappings();
        if (mappingPaths.size() == 0) {
            return;
        }
        ActionEngine actionEngine = new ActionEngine(module, controller.getControllerClass(), controller.getControllerObject(), action.getMethod());
        for (String mappingPath : mappingPaths.keySet()) {
            List<Mapping> mappings = MappingFactory.parse(mappingPath);
            MappingNode target = controllerNode;
            for (Mapping mapping : mappings) {
                if (mapping.getDefinition().length() == 0) continue;
                MappingNode temp = target.getChild(mapping.getDefinition());
                if (temp == null) {
                    temp = new MappingNode(mapping);
                    target.linkAsChild(temp);
                }
                target = temp;
            }
            for (ReqMethod method : mappingPaths.get(mappingPath)) {
                LinkedEngine linkedActionEngine = new LinkedEngine(controllerEngine, actionEngine, target);
                target.getLeafEngines().addEngine(method, linkedActionEngine);
            }
        }
    }

    private void check(MappingNode tree, MappingNode parent, String prefix) {
        MappingNode sibling = null;
        for (MappingNode child = parent.getLeftMostChild(); child != null; child = child.getSibling()) {
            if (sibling != null && child.compareTo(sibling) == 0) {
                logger.error((Object)("mapping conflicts: '" + child.getMapping().getDefinition() + "' conflicts with '" + sibling.getMapping().getDefinition() + "' in '" + prefix + "'; here is the mapping tree, " + "you can find the conflict in it:\n" + PrinteHelper.list(tree)));
                throw new IllegalArgumentException("mapping conflicts: '" + child.getMapping().getDefinition() + "' conflicts with '" + sibling.getMapping().getDefinition() + "' in '" + prefix + "'");
            }
            this.check(tree, child, prefix + child.getMapping().getDefinition());
            sibling = child;
        }
    }
}

