/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.mapping;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.paoding.rose.web.impl.mapping.ConstantMapping;
import net.paoding.rose.web.impl.mapping.Mapping;
import net.paoding.rose.web.impl.mapping.MappingNode;
import net.paoding.rose.web.impl.mapping.MatchResult;
import net.paoding.rose.web.impl.mapping.MatchResultImpl;

public class RegexMapping
implements Mapping {
    private MappingNode mappingNode;
    private final String definition;
    private final String paramName;
    private final Pattern pattern;
    private final String regex;

    public RegexMapping(String definition, String name, String regex) {
        this.definition = definition;
        this.paramName = name;
        this.regex = this.xx(regex);
        this.pattern = Pattern.compile("^" + this.regex);
    }

    private String xx(String regex) {
        if (regex == null || regex.length() == 0) {
            regex = "[^/]+";
        } else if ("+".equals(regex)) {
            regex = ".+";
        } else if ("?".equals(regex)) {
            regex = ".?";
        } else if ("*".equals(regex)) {
            regex = ".*";
        } else if ("n".equals(regex) || "number".equals(regex)) {
            regex = "[0-9]+";
        } else if ("w".equals(regex) || "word".equals(regex)) {
            regex = "\\w+";
        } else if ("id".equals(regex)) {
            regex = "[0-9a-zA-Z_-]+";
        }
        return regex;
    }

    @Override
    public MappingNode getMappingNode() {
        return this.mappingNode;
    }

    @Override
    public void setMappingNode(MappingNode mappingNode) {
        this.mappingNode = mappingNode;
    }

    @Override
    public String getParameterName() {
        return this.paramName;
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public MatchResult match(CharSequence path) {
        Matcher matcher = this.pattern.matcher(path);
        if (!matcher.find()) {
            return null;
        }
        String value = matcher.group();
        while (value.length() > 0 && value.charAt(value.length() - 1) == '/') {
            value = value.substring(0, value.length() - 1);
        }
        MatchResultImpl mr = new MatchResultImpl(this.mappingNode, value);
        mr.setParameter(this.paramName);
        return mr;
    }

    @Override
    public int compareTo(Mapping o) {
        if (o instanceof ConstantMapping) {
            return -((ConstantMapping)o).compareTo(this);
        }
        if (o instanceof RegexMapping) {
            RegexMapping t = (RegexMapping)o;
            if (this.regex.equals(t.regex) || this.definition.equals(t.definition)) {
                return 0;
            }
            boolean thisIsDigit = this.pattern.matcher("123456").find();
            boolean thatIsDigit = t.pattern.matcher("123456").find();
            if (thisIsDigit && !thatIsDigit) {
                return -1;
            }
            if (!thisIsDigit && thatIsDigit) {
                return 1;
            }
            if (!this.pattern.matcher("/").find() && t.pattern.matcher("/").find()) {
                return -1;
            }
            if (this.pattern.matcher("/").find() && !t.pattern.matcher("/").find()) {
                return 1;
            }
            if (!this.pattern.matcher(".").find() && t.pattern.matcher(".").find()) {
                return -1;
            }
            if (this.pattern.matcher(".").find() && !t.pattern.matcher(".").find()) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        return "RegexMappingMapping[" + this.definition + ", regex=" + this.pattern + "]";
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("^[0-9]+");
        Matcher matcher = p.matcher("56789/asd");
        System.out.println(matcher.find());
        String value = matcher.group();
        while (value.length() > 0 && value.charAt(value.length() - 1) == '/') {
            value = value.substring(0, value.length() - 1);
        }
        System.out.println("value=" + value);
    }
}

