/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.mapping;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.paoding.rose.util.RoseStringUtil;
import net.paoding.rose.web.impl.mapping.MappingPattern;

public enum MatchMode {
    STARTS_WITH{

        @Override
        public MappingPattern compile(final String conf, boolean regex) {
            if (regex) {
                return new MappingPattern(){
                    final Pattern pattern;
                    {
                        this.pattern = Pattern.compile("^" + conf + "($|/)");
                    }

                    @Override
                    public MatchResult match(CharSequence path) {
                        Matcher matcher = this.pattern.matcher(path);
                        return matcher.find() ? matcher : null;
                    }

                    public String toString() {
                        return this.pattern.toString();
                    }
                };
            }
            return new MappingPattern(){
                private final SimpleMatchResult simpleMatchResult;
                {
                    this.simpleMatchResult = new SimpleMatchResult(conf);
                }

                @Override
                public MatchResult match(CharSequence path) {
                    boolean matched = RoseStringUtil.startsWith(path, conf);
                    if (!matched || path.length() > conf.length() && path.charAt(conf.length()) != '/') {
                        return null;
                    }
                    return this.simpleMatchResult;
                }

                public String toString() {
                    return conf;
                }
            };
        }
    }
    ,
    EQUALS{

        @Override
        public MappingPattern compile(final String conf, boolean regex) {
            if (regex) {
                return new MappingPattern(){
                    final Pattern pattern;
                    {
                        this.pattern = Pattern.compile("^" + conf + "/?$");
                    }

                    @Override
                    public MatchResult match(CharSequence path) {
                        Matcher matcher = this.pattern.matcher(path);
                        return matcher.find() ? matcher : null;
                    }

                    public String toString() {
                        return this.pattern.toString();
                    }
                };
            }
            return new MappingPattern(){
                private final SimpleMatchResult simpleMatchResult;
                {
                    this.simpleMatchResult = new SimpleMatchResult(conf);
                }

                @Override
                public MatchResult match(CharSequence inputPath) {
                    if (inputPath.length() > conf.length()) {
                        if (inputPath.length() == conf.length() + 1) {
                            boolean matched = RoseStringUtil.startsWith(inputPath, conf);
                            if (!matched || inputPath.charAt(conf.length()) != '/') {
                                return null;
                            }
                            return this.simpleMatchResult;
                        }
                        return null;
                    }
                    return conf.equals(inputPath) ? this.simpleMatchResult : null;
                }

                public String toString() {
                    return conf;
                }
            };
        }
    };


    public abstract MappingPattern compile(String var1, boolean var2);

    private static class SimpleMatchResult
    implements MatchResult {
        private final String conf;

        public SimpleMatchResult(String conf) {
            this.conf = conf;
        }

        @Override
        public String group() {
            return this.conf;
        }

        @Override
        public String group(int group) {
            return this.conf;
        }

        @Override
        public int end() {
            return 0;
        }

        @Override
        public int end(int group) {
            return 0;
        }

        @Override
        public int groupCount() {
            return 0;
        }

        @Override
        public int start() {
            return 0;
        }

        @Override
        public int start(int group) {
            return 0;
        }
    }
}

