/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.mapping;

import java.util.ArrayList;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.impl.mapping.EngineGroup;
import net.paoding.rose.web.impl.mapping.EngineGroupImpl;
import net.paoding.rose.web.impl.mapping.Mapping;
import net.paoding.rose.web.impl.mapping.MatchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MappingNode
implements Comparable<MappingNode> {
    protected static final Log logger = LogFactory.getLog(MappingNode.class);
    private final Mapping mapping;
    private MappingNode leftMostChild;
    private MappingNode sibling;
    private int ammountOfRegexChildren = -1;
    private final EngineGroup leafEngines = new EngineGroupImpl();
    private final EngineGroup middleEngines = new EngineGroupImpl();

    public MappingNode(Mapping mapping) {
        this.mapping = mapping;
        this.mapping.setMappingNode(this);
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public String getMappingPath() {
        return this.mapping.getDefinition();
    }

    public MappingNode getLeftMostChild() {
        return this.leftMostChild;
    }

    public MappingNode getSibling() {
        return this.sibling;
    }

    public final boolean isLeaf() {
        return this.leftMostChild == null;
    }

    public void linkAsChild(MappingNode child) {
        if (this.leftMostChild == null) {
            this.leftMostChild = child;
        } else {
            MappingNode prev = null;
            MappingNode position = this.leftMostChild;
            while (true) {
                if (position == null) {
                    prev.sibling = child;
                    break;
                }
                int c = child.getMapping().compareTo(position.getMapping());
                if (c < 0) {
                    child.sibling = position;
                    if (prev == null) {
                        this.leftMostChild = child;
                        break;
                    }
                    prev.sibling = child;
                    break;
                }
                prev = position;
                position = position.sibling;
            }
        }
    }

    public MappingNode getChild(String mapping) {
        MappingNode sibling = this.leftMostChild;
        while (sibling != null) {
            if (sibling.getMapping().getDefinition().equals(mapping)) {
                return sibling;
            }
            sibling = sibling.sibling;
        }
        return null;
    }

    public EngineGroup getLeafEngines() {
        return this.leafEngines;
    }

    public EngineGroup getMiddleEngines() {
        return this.middleEngines;
    }

    public ArrayList<MatchResult> match(RequestPath requestPath) {
        ArrayList<MatchResult> matchResults = new ArrayList<MatchResult>(16);
        boolean debugEnabled = logger.isDebugEnabled();
        MappingNode curNode = this;
        String remaining = requestPath.getRosePath();
        MatchResult last = null;
        while (true) {
            if ((last = curNode.getMapping().match(remaining)) != null && last.getParameterName() == null) {
                if (curNode.ammountOfRegexChildren < 0) {
                    curNode.ammountOfRegexChildren = this.countRegexChildren(curNode);
                }
                if (curNode.ammountOfRegexChildren == 0 && remaining.length() > last.getValue().length() && remaining.charAt(last.getValue().length()) != '/') {
                    last = null;
                }
            }
            if (last == null) {
                if (curNode.sibling == null) {
                    if (debugEnabled) {
                        logger.debug((Object)("['" + requestPath.getRosePath() + "'] not matched"));
                    }
                    return null;
                }
                curNode = curNode.sibling;
                continue;
            }
            if (debugEnabled) {
                logger.debug((Object)("['" + requestPath.getRosePath() + "'] matched(" + (matchResults.size() + 1) + "): '" + last + "'"));
            }
            matchResults.add(last);
            remaining = remaining.substring(last.getValue().length());
            if (remaining.length() == 0) {
                if (debugEnabled) {
                    logger.debug((Object)("['" + requestPath.getRosePath() + "'] matched over."));
                }
                return matchResults;
            }
            if (curNode.leftMostChild == null) {
                if (debugEnabled) {
                    logger.debug((Object)("['" + requestPath.getRosePath() + "'] not matched"));
                }
                return null;
            }
            curNode = curNode.leftMostChild;
        }
    }

    private int countRegexChildren(MappingNode curNode) {
        int ammountOfRegexChildren = 0;
        MappingNode child = curNode.leftMostChild;
        while (child != null) {
            if (child.getMapping().getParameterName() != null) {
                ++ammountOfRegexChildren;
            }
            child = child.sibling;
        }
        return ammountOfRegexChildren;
    }

    @Override
    public int compareTo(MappingNode target) {
        return this.getMapping().compareTo(target.getMapping());
    }

    public void destroy() {
        this.leafEngines.destroy();
        MappingNode c = this.leftMostChild;
        while (c != null) {
            c.destroy();
            c = c.sibling;
        }
        this.middleEngines.destroy();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MappingNode)) {
            return false;
        }
        MappingNode target = (MappingNode)obj;
        return this.compareTo(target) == 0;
    }

    public int hashCode() {
        return this.getMapping().hashCode();
    }

    public String toString() {
        return this.getMappingPath();
    }
}

