/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.paoding.rose.web.impl.mapping.ConstantMapping;
import net.paoding.rose.web.impl.mapping.Mapping;
import net.paoding.rose.web.impl.mapping.RegexMapping;
import org.apache.commons.lang.math.NumberUtils;

public class MappingFactory {
    public static List<Mapping> parse(String path) {
        if (path.equals("/")) {
            path = "";
        } else if (path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        if (path.length() > 1 && path.endsWith("/")) {
            if (path.endsWith("//")) {
                throw new IllegalArgumentException("invalid path '" + path + "' : don't end with more than one '/'");
            }
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Mapping> mappings = new ArrayList<Mapping>(8);
        char[] chars = new char[path.length()];
        path.getChars(0, path.length(), chars, 0);
        int paramBegin = -1;
        int paramNameEnd = -1;
        int constantBegin = -1;
        int bracketDeep = 0;
        boolean startsWithBracket = true;
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '$': {
                    if (i + 1 >= chars.length) {
                        throw new IllegalArgumentException("invalid string '" + path + "', don't end with '$'");
                    }
                    if (constantBegin >= 0) {
                        mappings.add(MappingFactory.createConstantMapping(path, constantBegin, i));
                        constantBegin = -1;
                    }
                    if (paramBegin >= 0) {
                        mappings.add(MappingFactory.createRegexMapping(path, paramBegin, paramNameEnd, i));
                        paramBegin = -1;
                        paramNameEnd = -1;
                    }
                    if (chars[i + 1] == '{') continue block7;
                    paramBegin = i + 1;
                    bracketDeep = 1;
                    startsWithBracket = false;
                    continue block7;
                }
                case '{': {
                    if (bracketDeep++ > 0) continue block7;
                    if (paramBegin < 0) {
                        paramBegin = i + 1;
                    } else {
                        mappings.add(MappingFactory.createRegexMapping(path, paramBegin, paramNameEnd, i));
                        paramBegin = -1;
                        paramNameEnd = -1;
                    }
                    if (constantBegin < 0) continue block7;
                    mappings.add(MappingFactory.createConstantMapping(path, constantBegin, i));
                    constantBegin = -1;
                    continue block7;
                }
                case ':': {
                    if (paramBegin < 0) {
                        throw new IllegalArgumentException("invalid string '" + path + "', wrong ':' at position " + i);
                    }
                    if (paramNameEnd > 0) {
                        throw new IllegalArgumentException("invalid string '" + path + "', duplicated ':' at position " + i);
                    }
                    paramNameEnd = i;
                    continue block7;
                }
                case '}': {
                    if (--bracketDeep > 0) continue block7;
                    if (paramBegin < 0) {
                        throw new IllegalArgumentException("invalid string '" + path + "', wrong '}' at position " + i);
                    }
                    mappings.add(MappingFactory.createRegexMapping(path, paramBegin, paramNameEnd, i));
                    paramBegin = -1;
                    paramNameEnd = -1;
                    continue block7;
                }
                case '/': {
                    if (paramBegin < 0) {
                        if (constantBegin >= 0) {
                            mappings.add(MappingFactory.createConstantMapping(path, constantBegin, i));
                        }
                        constantBegin = i;
                        continue block7;
                    }
                    if (bracketDeep == 0 || bracketDeep == 1 && !startsWithBracket) {
                        mappings.add(MappingFactory.createRegexMapping(path, paramBegin, paramNameEnd, i));
                        paramBegin = -1;
                        constantBegin = i;
                        paramNameEnd = -1;
                        bracketDeep = 0;
                        continue block7;
                    }
                }
                default: {
                    if (constantBegin != -1 || paramBegin != -1) continue block7;
                    constantBegin = i;
                }
            }
        }
        if (constantBegin >= 0) {
            mappings.add(MappingFactory.createConstantMapping(path, constantBegin, chars.length));
            constantBegin = -1;
        }
        if (paramBegin >= 0) {
            mappings.add(MappingFactory.createRegexMapping(path, paramBegin, paramNameEnd, chars.length));
            paramBegin = -1;
            paramNameEnd = -1;
        }
        return mappings;
    }

    private static Mapping createConstantMapping(String userDefinedMapping, int constantBegin, int i) {
        if (constantBegin == i) {
            throw new IllegalArgumentException(userDefinedMapping + "  constantBegin=" + constantBegin);
        }
        return new ConstantMapping(userDefinedMapping.substring(constantBegin, i));
    }

    private static Mapping createRegexMapping(String userDefinedMapping, int paramBegin, int paramNameEnd, int i) {
        String rawName = userDefinedMapping.substring(paramBegin, paramNameEnd >= 0 ? paramNameEnd : i);
        if (rawName.length() == 0) {
            throw new IllegalArgumentException("invalid string '" + userDefinedMapping + "', wrong paramName at position " + paramBegin);
        }
        String name = rawName;
        if (NumberUtils.isDigits((String)rawName)) {
            name = "$" + rawName;
        }
        String regex = "";
        if (paramNameEnd >= 0) {
            regex = userDefinedMapping.substring(paramNameEnd + 1, i);
        }
        return new RegexMapping("{" + rawName + "}", name, regex);
    }
}

