/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.paoding.rose.web.annotation.ReqMethod;
import net.paoding.rose.web.impl.mapping.EngineGroup;
import net.paoding.rose.web.impl.thread.LinkedEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EngineGroupImpl
implements EngineGroup {
    private static final Log logger = LogFactory.getLog(EngineGroup.class);
    private static final int ARRAY_SIZE = ReqMethod.ALL.parse().size();
    private static final LinkedEngine[] emptyEngines = new LinkedEngine[0];
    private final LinkedEngine[][] engines;
    private int engineCount;
    private transient String toStringCache;
    private transient List<ReqMethod> allowedMethodsCache;
    private boolean destroyed = false;

    public EngineGroupImpl() {
        LinkedEngine[][] engines = new LinkedEngine[ARRAY_SIZE][];
        Arrays.fill((Object[])engines, emptyEngines);
        this.engines = engines;
    }

    @Override
    public void addEngine(ReqMethod method, LinkedEngine engine) {
        for (ReqMethod md : method.parse()) {
            LinkedEngine[] methodEngines = this.engines[md.ordinal()];
            if (methodEngines.length == 0) {
                methodEngines = new LinkedEngine[]{engine};
            } else {
                methodEngines = Arrays.copyOf(methodEngines, methodEngines.length + 1);
                methodEngines[methodEngines.length - 1] = engine;
            }
            this.engines[md.ordinal()] = methodEngines;
            ++this.engineCount;
        }
        this.clearCache();
    }

    @Override
    public int size() {
        return this.engineCount;
    }

    @Override
    public LinkedEngine[] getEngines(ReqMethod method) {
        if (method == null) {
            return emptyEngines;
        }
        if (method == ReqMethod.ALL) {
            throw new IllegalArgumentException("method");
        }
        return this.engines[method.ordinal()];
    }

    @Override
    public boolean isMethodAllowed(ReqMethod method) {
        return method != null && this.engines[method.ordinal()].length > 0;
    }

    @Override
    public List<ReqMethod> getAllowedMethods() {
        if (this.allowedMethodsCache == null) {
            ArrayList<ReqMethod> allowedMethods = new ArrayList<ReqMethod>();
            for (ReqMethod method : ReqMethod.ALL.parse()) {
                LinkedEngine[] methodEngines = this.engines[method.ordinal()];
                if (methodEngines.length <= 0) continue;
                allowedMethods.add(method);
            }
            this.allowedMethodsCache = Collections.unmodifiableList(allowedMethods);
        }
        return this.allowedMethodsCache;
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            return;
        }
        this.destroyed = true;
        LinkedEngine[][] arr$ = this.engines;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LinkedEngine[] methodEngines;
            for (LinkedEngine engine : methodEngines = arr$[i$]) {
                try {
                    engine.destroy();
                }
                catch (Throwable e) {
                    logger.error((Object)"", e);
                }
            }
        }
    }

    @Override
    public String toString() {
        if (this.toStringCache == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            int oriLen = sb.length();
            for (ReqMethod method : this.getAllowedMethods()) {
                sb.append(method.toString()).append(", ");
            }
            if (sb.length() > oriLen) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("]");
            this.toStringCache = sb.toString();
        }
        return this.toStringCache;
    }

    private void clearCache() {
        this.allowedMethodsCache = null;
        this.toStringCache = null;
    }
}

