/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.mapping;

import net.paoding.rose.util.RoseStringUtil;
import net.paoding.rose.web.impl.mapping.Mapping;
import net.paoding.rose.web.impl.mapping.MappingNode;
import net.paoding.rose.web.impl.mapping.MatchResult;
import net.paoding.rose.web.impl.mapping.MatchResultImpl;

public class ConstantMapping
implements Mapping {
    private MappingNode mappingNode;
    private final String definition;

    public ConstantMapping(String definition) {
        this.definition = definition;
    }

    @Override
    public MappingNode getMappingNode() {
        return this.mappingNode;
    }

    @Override
    public void setMappingNode(MappingNode mappingNode) {
        this.mappingNode = mappingNode;
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public String getParameterName() {
        return null;
    }

    @Override
    public MatchResult match(CharSequence input) {
        boolean matched = RoseStringUtil.startsWith(input, this.definition);
        return !matched ? null : new MatchResultImpl(this.mappingNode, this.definition);
    }

    @Override
    public int compareTo(Mapping o) {
        if (o instanceof ConstantMapping) {
            String opath = ((ConstantMapping)o).definition;
            if (opath.length() == this.definition.length()) {
                return this.definition.compareTo(opath);
            }
            if (this.definition.length() == 0) {
                return 1;
            }
            return opath.length() - this.definition.length();
        }
        return -1;
    }

    @Override
    public String toString() {
        return "ConstantMapping[" + this.definition + "]";
    }
}

