/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.paoding.rose.web.Dispatcher;
import net.paoding.rose.web.annotation.ReqMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.util.WebUtils;

public class RequestPath {
    private static Log logger = LogFactory.getLog(RequestPath.class);
    private ReqMethod method;
    private String uri;
    private String ctxpath;
    private String rosePath;
    private String modulePath;
    private String controllerPathInfo;
    private String controllerPath;
    private String actionPath;
    private Dispatcher dispatcher;

    public RequestPath(ReqMethod method, String uri, String ctxpath, Dispatcher dispatcher) {
        this.setMethod(method);
        this.setUri(uri);
        this.setCtxpath(ctxpath);
        this.setDispatcher(dispatcher);
        this.setRosePath(uri.substring(ctxpath.length()));
    }

    public RequestPath(HttpServletRequest request) {
        String uri;
        this.setMethod(this.parseMethod(request));
        this.setCtxpath(request.getContextPath());
        String invocationCtxpath = null;
        if (WebUtils.isIncludeRequest((ServletRequest)request)) {
            this.setDispatcher(Dispatcher.INCLUDE);
            uri = (String)request.getAttribute("javax.servlet.include.request_uri");
            invocationCtxpath = (String)request.getAttribute("javax.servlet.include.context_path");
            this.setRosePath((String)request.getAttribute("javax.servlet.include.servlet_path"));
        } else {
            uri = request.getRequestURI();
            this.setRosePath(request.getServletPath());
            if (request.getAttribute("javax.servlet.forward.request_uri") == null) {
                this.setDispatcher(Dispatcher.REQUEST);
            } else {
                this.setDispatcher(Dispatcher.FORWARD);
            }
        }
        if (uri.startsWith("http://") || uri.startsWith("https://")) {
            int start = uri.indexOf(47, 9);
            uri = start == -1 ? "" : uri.substring(start);
        }
        if (uri.indexOf(37) != -1) {
            try {
                String encoding = request.getCharacterEncoding();
                if (encoding == null || encoding.length() == 0) {
                    encoding = "UTF-8";
                }
                uri = URLDecoder.decode(uri, encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        this.setUri(uri);
        if (this.getCtxpath().length() <= 1) {
            this.setRosePath(this.getUri());
        } else {
            this.setRosePath(this.getUri().substring((invocationCtxpath == null ? this.getCtxpath() : invocationCtxpath).length()));
        }
    }

    private ReqMethod parseMethod(HttpServletRequest request) {
        String queryString;
        ReqMethod reqMethod = ReqMethod.parse(request.getMethod());
        if (reqMethod != null && reqMethod.equals((Object)ReqMethod.POST) && (queryString = request.getQueryString()) != null) {
            int inBodyStart;
            ReqMethod _reqMethod;
            String method;
            boolean methodChanged = false;
            int start = queryString.indexOf("_method=");
            if (start == 0 || start > 0 && queryString.charAt(start - 1) == '&') {
                int end = queryString.indexOf(38, start);
                method = queryString.substring(start + "_method=".length(), end > 0 ? end : queryString.length());
                _reqMethod = ReqMethod.parse(method);
                if (_reqMethod != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("override http method from POST to " + (Object)((Object)_reqMethod)));
                    }
                    reqMethod = _reqMethod;
                    methodChanged = true;
                }
            }
            if (!methodChanged && ((inBodyStart = queryString.indexOf("_method_in_body=1")) == 0 || inBodyStart > 0 && queryString.charAt(inBodyStart - 1) == '&') && (_reqMethod = ReqMethod.parse(method = request.getParameter("_method"))) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("override http method from POST to " + (Object)((Object)_reqMethod)));
                }
                reqMethod = _reqMethod;
                methodChanged = true;
            }
        }
        return reqMethod;
    }

    public boolean isIncludeRequest() {
        return this.dispatcher == Dispatcher.INCLUDE;
    }

    public boolean isForwardRequest() {
        return this.dispatcher == Dispatcher.FORWARD;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public ReqMethod getMethod() {
        return this.method;
    }

    public void setMethod(ReqMethod method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getCtxpath() {
        return this.ctxpath;
    }

    public void setCtxpath(String ctxpath) {
        this.ctxpath = ctxpath;
    }

    public String getRosePath() {
        return this.rosePath;
    }

    public void setRosePath(String rosePath) {
        if (rosePath.equals("") || rosePath.equals("/")) {
            this.rosePath = "";
            return;
        }
        if (rosePath.charAt(rosePath.length() - 1) == '/') {
            rosePath = rosePath.substring(0, rosePath.length() - 1);
        }
        this.rosePath = rosePath;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public String getControllerPathInfo() {
        if (this.controllerPathInfo == null) {
            this.controllerPathInfo = this.rosePath.substring(this.modulePath.length());
        }
        return this.controllerPathInfo;
    }

    public String getControllerPath() {
        return this.controllerPath;
    }

    public void setControllerPath(String controllerPath) {
        this.controllerPath = controllerPath;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    public String toString() {
        return "ctxpath=" + this.ctxpath + "; pathInfo=" + this.rosePath + "; modulePath=" + this.modulePath + "; controllerPath=" + this.controllerPath + "; actionPath=" + this.actionPath;
    }
}

