/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web;

import net.paoding.rose.web.ControllerInterceptor;
import net.paoding.rose.web.InterceptorDelegate;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.InvocationChain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OncePerRequestInterceptorDelegate
extends InterceptorDelegate {
    private static Log logger = LogFactory.getLog(OncePerRequestInterceptorDelegate.class);
    private final String filteredKey;

    public OncePerRequestInterceptorDelegate(ControllerInterceptor interceptor) {
        super(interceptor);
        String realInterceptorName = OncePerRequestInterceptorDelegate.getMostInnerInterceptor(interceptor).getClass().getName();
        this.filteredKey = "$$paoding-rose.interceptor.oncePerRequest.." + realInterceptorName;
    }

    @Override
    public Object roundInvocation(Invocation inv, InvocationChain chain) throws Exception {
        boolean tobeIntercepted;
        Invocation tempInv = inv;
        int preCount = 0;
        do {
            boolean bl = tobeIntercepted = tempInv.getAttribute(this.filteredKey) == null;
            if (!tobeIntercepted) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)(preCount + "-th preInvocation found filteredKey:" + this.filteredKey));
                break;
            }
            tempInv = tempInv.getPreInvocation();
            ++preCount;
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(preCount + "-th preInvocation:" + tempInv));
        } while (tempInv != null);
        if (tobeIntercepted) {
            inv.setAttribute(this.filteredKey, Boolean.TRUE);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("do oncePerRequest interceptor.roundInvocation: " + this.getName()));
            }
            return super.roundInvocation(inv, chain);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("skip oncePerRequest interceptor.roundInvocation: " + this.getName()));
        }
        return chain.doNext();
    }

    @Override
    public final void afterCompletion(Invocation inv, Throwable ex) throws Exception {
        if (inv.getAttribute(this.filteredKey) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("do oncePerRequest interceptor.afterCompletion: " + this.getName()));
            }
            super.afterCompletion(inv, ex);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("skip oncePerRequest interceptor.afterCompletion: " + this.getName()));
        }
    }

    @Override
    public String toString() {
        return "oncePerRequest." + this.interceptor.toString();
    }
}

