/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web;

import javax.servlet.http.HttpServletRequest;
import net.paoding.rose.web.Invocation;

public class InvocationUtils {
    private static final ThreadLocal<HttpServletRequest> currentRequests = new ThreadLocal();

    public static void bindInvocationToRequest(Invocation inv, HttpServletRequest request) {
        request.setAttribute("$$paoding-rose.invocation", (Object)inv);
    }

    public static void unbindInvocationFromRequest(HttpServletRequest request) {
        request.removeAttribute("$$paoding-rose.invocation");
    }

    public static Invocation getInvocation(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        return (Invocation)request.getAttribute("$$paoding-rose.invocation");
    }

    public static void unindRequestFromCurrentThread() {
        currentRequests.remove();
    }

    public static void bindRequestToCurrentThread(HttpServletRequest request) {
        if (request == null) {
            InvocationUtils.unindRequestFromCurrentThread();
        } else {
            currentRequests.set(request);
        }
    }

    public static HttpServletRequest getCurrentThreadRequest() {
        return currentRequests.get();
    }

    public static Invocation getCurrentThreadInvocation() {
        return InvocationUtils.getInvocation(currentRequests.get());
    }
}

