/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web;

import java.lang.reflect.Method;
import net.paoding.rose.web.ControllerInterceptor;
import net.paoding.rose.web.Dispatcher;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.InvocationChain;
import net.paoding.rose.web.advancedinterceptor.ActionSelector;
import net.paoding.rose.web.advancedinterceptor.DispatcherSelector;
import net.paoding.rose.web.advancedinterceptor.Named;
import net.paoding.rose.web.advancedinterceptor.Ordered;
import net.paoding.rose.web.impl.thread.AfterCompletion;
import org.springframework.util.Assert;

public class InterceptorDelegate
implements Ordered,
Named,
ControllerInterceptor,
AfterCompletion,
ActionSelector,
DispatcherSelector,
Comparable<InterceptorDelegate> {
    protected final ControllerInterceptor interceptor;
    private String name;
    private boolean isAfterCompletion;
    private boolean isDispatcherSelector;

    public static ControllerInterceptor getMostInnerInterceptor(ControllerInterceptor interceptor) {
        ControllerInterceptor temp = interceptor;
        while (temp instanceof InterceptorDelegate) {
            temp = ((InterceptorDelegate)temp).getInterceptor();
        }
        return temp;
    }

    public InterceptorDelegate(ControllerInterceptor interceptor) {
        Assert.notNull((Object)interceptor);
        this.interceptor = interceptor;
        this.isAfterCompletion = interceptor instanceof AfterCompletion;
        this.isDispatcherSelector = interceptor instanceof DispatcherSelector;
    }

    public ControllerInterceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public String getName() {
        if (this.interceptor instanceof Named) {
            this.name = ((Named)((Object)this.interceptor)).getName();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.interceptor instanceof Named) {
            ((Named)((Object)this.interceptor)).setName(name);
        }
    }

    @Override
    public int getPriority() {
        if (this.interceptor instanceof Ordered) {
            return ((Ordered)((Object)this.interceptor)).getPriority();
        }
        return 0;
    }

    @Override
    public boolean isForAction(Class<?> controllerClazz, Method actionMethod) {
        if (this.interceptor instanceof ActionSelector) {
            return ((ActionSelector)((Object)this.interceptor)).isForAction(controllerClazz, actionMethod);
        }
        return true;
    }

    @Override
    public boolean isForDispatcher(Dispatcher dispatcher) {
        if (this.isDispatcherSelector) {
            return ((DispatcherSelector)((Object)this.interceptor)).isForDispatcher(dispatcher);
        }
        return true;
    }

    @Override
    public Object roundInvocation(Invocation inv, InvocationChain chain) throws Exception {
        return this.interceptor.roundInvocation(inv, chain);
    }

    @Override
    public void afterCompletion(Invocation inv, Throwable ex) throws Exception {
        if (this.isAfterCompletion) {
            ((AfterCompletion)((Object)this.interceptor)).afterCompletion(inv, ex);
        }
    }

    @Override
    public int compareTo(InterceptorDelegate o) {
        if (o == this) {
            return 0;
        }
        if (this.getPriority() > o.getPriority()) {
            return -1;
        }
        if (this.getPriority() < o.getPriority()) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return InterceptorDelegate.getMostInnerInterceptor(this).getClass().getName();
    }
}

