/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringUtils {
    private static Log logger = LogFactory.getLog(SpringUtils.class);

    public static <T> T getBean(ListableBeanFactory bf, Class<?> beanClass) {
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)bf, beanClass);
        Object bean = names.length == 0 ? null : bf.getBean(names[0]);
        return (T)bean;
    }

    public static String[] getBeanNames(ListableBeanFactory bf, Class<?> beanClass) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)bf, beanClass);
    }

    public static <T> List<T> getBeans(ListableBeanFactory bf, Class<T> beanClass) {
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)bf, beanClass);
        ArrayList<Object> beans = new ArrayList<Object>(names.length);
        for (String name : names) {
            beans.add(bf.getBean(name));
        }
        return beans;
    }

    public static <T> T getBean(ListableBeanFactory bf, String beanName) {
        Object bean = bf.containsBean(beanName) ? bf.getBean(beanName) : null;
        return (T)bean;
    }

    public static <T> T createBean(Class<?> clazz, ApplicationContext context) {
        Object bean = context.getAutowireCapableBeanFactory().createBean(clazz, 0, false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("create spring bean: " + bean.getClass() + "@" + bean.hashCode()));
        }
        return (T)bean;
    }

    public static <T> T autowire(T bean, ApplicationContext context) {
        context.getAutowireCapableBeanFactory().autowireBeanProperties(bean, 0, false);
        Object ret = context.getAutowireCapableBeanFactory().initializeBean(bean, bean.getClass().getName());
        return (T)ret;
    }
}

