/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.util;

import org.apache.commons.lang.StringUtils;

public class RoseStringUtil {
    public static String relativePathToModulePath(String relativePath) {
        if (relativePath == null) {
            throw new NullPointerException();
        }
        if (relativePath.length() == 0) {
            return "";
        }
        return StringUtils.removeEnd((String)("/" + relativePath), (String)"/");
    }

    public static String mappingPath(String mappingPath) {
        if (mappingPath.length() != 0) {
            mappingPath = StringUtils.removeEnd((String)mappingPath, (String)"/");
            while (mappingPath.indexOf("//") != -1) {
                mappingPath = mappingPath.replace("//", "/");
            }
        }
        return mappingPath;
    }

    public static boolean startsWith(CharSequence input, String prefix) {
        if (input.length() < prefix.length()) {
            return false;
        }
        if (input.getClass() == String.class) {
            return ((String)input).startsWith(prefix);
        }
        int len = prefix.length();
        for (int i = 0; i < len; ++i) {
            char ci;
            char pi = input.charAt(i);
            if (pi == (ci = prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(String[] patterns, String value) {
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (pattern.equals(value)) {
                return true;
            }
            if (pattern.endsWith("*") && value.startsWith(pattern.substring(0, pattern.length() - 1))) {
                return true;
            }
            if (!pattern.startsWith("*") || !value.endsWith(pattern.substring(1))) continue;
            return true;
        }
        return false;
    }
}

