/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.paoding.rose.web.InterceptorDelegate;
import net.paoding.rose.web.ParamValidator;
import net.paoding.rose.web.annotation.ReqMethod;
import net.paoding.rose.web.impl.mapping.EngineGroup;
import net.paoding.rose.web.impl.mapping.MappingNode;
import net.paoding.rose.web.impl.module.ControllerRef;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.thread.ActionEngine;
import net.paoding.rose.web.impl.thread.LinkedEngine;
import net.paoding.rose.web.paramresolver.ParamResolver;

public class PrinteHelper {
    public static String dumpModules(List<Module> modules) {
        StringBuilder sb = new StringBuilder(4028);
        sb.append("\n--------Modules(Total ").append(modules.size()).append(")--------");
        sb.append("\n");
        for (int i = 0; i < modules.size(); ++i) {
            Module module = modules.get(i);
            sb.append("module ").append(i + 1).append(":");
            sb.append("\n\tmappingPath='").append(module.getMappingPath());
            sb.append("';\n\tpackageRelativePath='").append(module.getRelativePath());
            sb.append("';\n\turl='").append(module.getUrl());
            sb.append("';\n\tcontrollers=[");
            List<ControllerRef> controllerMappings = module.getControllers();
            for (ControllerRef controller : controllerMappings) {
                sb.append("'").append(Arrays.toString(controller.getMappingPaths())).append("'=").append(controller.getControllerClass().getSimpleName()).append(", ");
            }
            if (!controllerMappings.isEmpty()) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("];\n\tparamResolvers=[");
            for (ParamResolver resolver : module.getCustomerResolvers()) {
                sb.append(resolver.getClass().getSimpleName()).append(", ");
            }
            if (module.getCustomerResolvers().size() > 0) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("];\n\tvalidators=[");
            for (ParamValidator validator : module.getValidators()) {
                sb.append(validator.getClass().getSimpleName()).append(", ");
            }
            if (module.getValidators().size() > 0) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("];\n\tinterceptors=[");
            for (InterceptorDelegate interceptor : module.getInterceptors()) {
                sb.append(interceptor.getName()).append("(").append(interceptor.getPriority()).append("), ");
            }
            if (module.getInterceptors().size() > 0) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("];\n\terrorHander=").append(module.getErrorHandler() == null ? "<null>" : module.getErrorHandler());
            sb.append("\n\n");
        }
        sb.append("--------end--------");
        return sb.toString();
    }

    public static String list(MappingNode root) {
        StringBuilder sb = new StringBuilder(512);
        PrinteHelper.println(root, "", -1, sb);
        return sb.toString();
    }

    private static void println(MappingNode node, String prefix, int deep, StringBuilder sb) {
        String gap = "    ";
        String tab = "";
        for (int i = 0; i < deep; ++i) {
            tab = tab + "    ";
        }
        String path = tab + prefix + node.getMappingPath();
        if (path.length() == 0) {
            path = "ROOT";
        }
        sb.append(path).append("\n");
        tab = tab + "    ";
        EngineGroup leaf = node.getLeafEngines();
        if (leaf.size() > 0) {
            for (ReqMethod method : leaf.getAllowedMethods()) {
                for (LinkedEngine engine : leaf.getEngines(method)) {
                    ActionEngine action = (ActionEngine)engine.getTarget();
                    Method m = action.getMethod();
                    Class<?> cc = action.getControllerClass();
                    sb.append(tab);
                    sb.append((Object)((Object)method) + "=\"" + cc.getSimpleName() + "#" + m.getName() + "\" ");
                    sb.append("package=\"" + m.getDeclaringClass().getPackage().getName() + "\"\n");
                }
            }
        }
        for (MappingNode child = node.getLeftMostChild(); child != null; child = child.getSibling()) {
            PrinteHelper.println(child, prefix + node.getMappingPath(), deep + 1, sb);
        }
    }
}

