/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.util;

import net.paoding.rose.web.Invocation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;

public class PlaceHolderUtils {
    public static final String DOLLAR = "$";
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final char PLACEHOLDER_INNER_PREFIX = '{';
    public static final String PLACEHOLDER_INNER_PREFIX_STRING = "{";
    public static final char PLACEHOLDER_SUFFIX_CHAR = '}';
    public static final String PLACEHOLDER_SUFFIX = "}";
    private static final Log logger = LogFactory.getLog(PlaceHolderUtils.class);

    public static String resolve(String text, Invocation inv) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        int startIndex = text.indexOf(PLACEHOLDER_PREFIX);
        if (startIndex == -1) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = null;
                String defaultValue = null;
                for (int i = startIndex + PLACEHOLDER_PREFIX.length(); i < endIndex; ++i) {
                    if (buf.charAt(i) != '?') continue;
                    placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), i);
                    defaultValue = buf.substring(i + 1, endIndex);
                    break;
                }
                if (placeholder == null) {
                    placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                }
                int nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                try {
                    int dot = placeholder.indexOf(46);
                    String attributeName = dot == -1 ? placeholder : placeholder.substring(0, dot);
                    String propertyPath = dot == -1 ? "" : placeholder.substring(dot + 1);
                    Object propVal = inv.getModel().get(attributeName);
                    if (propVal != null) {
                        if (propertyPath.length() > 0) {
                            propVal = new BeanWrapperImpl(propVal).getPropertyValue(propertyPath);
                        }
                    } else {
                        propVal = "flash".equals(attributeName) ? inv.getFlash().get(propertyPath) : inv.getParameter(placeholder);
                    }
                    if (propVal == null) {
                        propVal = defaultValue;
                    }
                    if (propVal == null) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Could not resolve placeholder '" + placeholder + "' in [" + text + "]."));
                        }
                    } else {
                        String toString = propVal.toString();
                        buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), toString);
                        nextIndex = startIndex + toString.length();
                    }
                }
                catch (Throwable ex) {
                    logger.warn((Object)("Could not resolve placeholder '" + placeholder + "' in [" + text + "] : " + ex));
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }
}

