/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.paoding.rose.load.LoadScope;
import net.paoding.rose.load.ResourceRef;
import net.paoding.rose.load.RoseScanner;
import net.paoding.rose.load.vfs.FileName;
import net.paoding.rose.load.vfs.FileObject;
import net.paoding.rose.load.vfs.FileSystemManager;
import net.paoding.rose.scanner.ModuleResource;
import net.paoding.rose.scanner.ModuleResourceProvider;
import net.paoding.rose.util.RoseStringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ModuleResourceProviderImpl
implements ModuleResourceProvider {
    private Log logger = LogFactory.getLog(ModuleResourceProviderImpl.class);

    @Override
    public List<ModuleResource> findModuleResources(LoadScope scope) throws IOException {
        Local local = new Local();
        Object[] controllersScope = scope.getScope("controllers");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[moduleResource] starting ...");
            this.logger.info((Object)("[moduleResource] call 'findFiles': to find classes or jar files by scope " + Arrays.toString(controllersScope)));
        }
        List refers = RoseScanner.getInstance().getJarOrClassesFolderResources((String[])controllersScope);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[moduleResource] exits from 'findFiles'");
            this.logger.info((Object)("[moduleResource] going to scan controllers from these folders or jar files:" + refers));
        }
        FileSystemManager fileSystem = new FileSystemManager();
        for (ResourceRef refer : refers) {
            Resource resource = refer.getResource();
            if (!refer.hasModifier("controllers")) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("[moduleResource] Ignored because not marked as 'controllers' in META-INF/rose.properties or META-INF/MANIFEST.MF: " + resource.getURI()));
                continue;
            }
            File resourceFile = resource.getFile();
            String urlString = "jar".equals(refer.getProtocol()) ? "jar:" + resourceFile.toURI() + "!/" : resourceFile.toURI().toString();
            FileObject rootObject = fileSystem.resolveFile(urlString);
            if (rootObject == null || !rootObject.exists()) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("[moduleResource] Ignored because not exists: " + urlString));
                continue;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("[moduleResource] start to scan moduleResource in file: " + rootObject));
            }
            try {
                int oldSize = local.moduleResourceList.size();
                this.deepScanImpl(local, rootObject, rootObject);
                int newSize = local.moduleResourceList.size();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("[moduleResource] got " + (newSize - oldSize) + " modules in " + rootObject));
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("[moduleResource] error happend when scanning " + rootObject), (Throwable)e);
            }
            fileSystem.clearCache();
        }
        this.afterScanning(local);
        this.logger.info((Object)("[moduleResource] found " + local.moduleResourceList.size() + " module resources "));
        return local.moduleResourceList;
    }

    protected void deepScanImpl(Local local, FileObject root, FileObject target) throws IOException {
        if ("controllers".equals(target.getName().getBaseName())) {
            this.checkModuleResourceCandidate(local, root, target, target);
        } else {
            FileObject[] children;
            for (FileObject child : children = target.getChildren()) {
                if (!child.getType().hasChildren()) continue;
                this.deepScanImpl(local, root, child);
            }
        }
    }

    protected void checkModuleResourceCandidate(Local local, FileObject root, FileObject topModuleFile, FileObject candidate) throws IOException {
        FileObject[] children;
        String relative = topModuleFile.getName().getRelativeName(candidate.getName());
        String mappingPath = null;
        String[] interceptedAllow = null;
        String[] interceptedDeny = null;
        ModuleResource parentModule = local.moduleResourceMap.get(candidate.getParent());
        FileObject rosePropertiesFile = candidate.getChild("rose.properties");
        if (rosePropertiesFile != null && rosePropertiesFile.exists()) {
            Properties p = new Properties();
            InputStream in = rosePropertiesFile.getContent().getInputStream();
            p.load(in);
            in.close();
            String ignored = p.getProperty("module.ignored", "false").trim();
            if ("true".equalsIgnoreCase(ignored) || "1".equalsIgnoreCase(ignored)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Ignored module(include submodules) by rose.properties[ignored=" + ignored + "]: " + candidate));
                }
                return;
            }
            mappingPath = p.getProperty("module.path");
            if (mappingPath != null) {
                String parentModulePlaceHolder;
                if ((mappingPath = mappingPath.trim()).indexOf(parentModulePlaceHolder = "${parent.module.path}") != -1) {
                    String parentModulePath = "";
                    if (candidate.getParent() != null) {
                        parentModulePath = parentModule == null ? "" : parentModule.getMappingPath();
                    }
                    mappingPath = mappingPath.replace(parentModulePlaceHolder, parentModulePath);
                }
                if (mappingPath.length() != 0 && !mappingPath.startsWith("/")) {
                    mappingPath = parentModule != null ? parentModule.getMappingPath() + "/" + mappingPath : (StringUtils.isNotEmpty((String)relative) ? relative + "/" + mappingPath : "/" + mappingPath);
                }
                mappingPath = RoseStringUtil.mappingPath(mappingPath);
            }
            String interceptedAllowStrings = p.getProperty("intercepted.allow");
            if ((interceptedAllowStrings = StringUtils.trimToEmpty((String)interceptedAllowStrings)).length() > 0) {
                interceptedAllow = StringUtils.split((String)interceptedAllowStrings, (String)",");
            }
            String interceptedDenyStrings = p.getProperty("intercepted.deny");
            if ((interceptedDenyStrings = StringUtils.trimToEmpty((String)interceptedDenyStrings)).length() > 0) {
                interceptedDeny = StringUtils.split((String)interceptedDenyStrings, (String)",");
            }
        }
        if (mappingPath == null) {
            mappingPath = parentModule != null ? parentModule.getMappingPath() + "/" + candidate.getName().getBaseName() : "";
        }
        ModuleResource moduleResource = new ModuleResource();
        moduleResource.setMappingPath(mappingPath);
        moduleResource.setModuleUrl(candidate.getURL());
        moduleResource.setRelativePath(RoseStringUtil.relativePathToModulePath(relative));
        moduleResource.setParent(parentModule);
        if (interceptedAllow != null) {
            moduleResource.setInterceptedAllow(interceptedAllow);
        }
        if (interceptedDeny != null) {
            moduleResource.setInterceptedDeny(interceptedDeny);
        }
        local.moduleResourceMap.put(candidate, moduleResource);
        local.moduleResourceList.add(moduleResource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("found module '" + mappingPath + "' in " + candidate.getURL()));
        }
        for (FileObject child : children = candidate.getChildren()) {
            if (!child.getType().hasContent() || child.getType().hasChildren()) continue;
            this.handlerModuleResource(local, root, candidate, child);
        }
        for (FileObject child : children) {
            if (!child.getType().hasChildren()) continue;
            this.checkModuleResourceCandidate(local, root, topModuleFile, child);
        }
    }

    protected void handlerModuleResource(Local local, FileObject rootObject, FileObject thisFolder, FileObject resource) throws IOException {
        FileName fileName = resource.getName();
        String bn = fileName.getBaseName();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("handlerModuleResource baseName=" + bn + "; file=" + fileName.getFileObject()));
        }
        if (bn.endsWith(".class") && bn.indexOf(36) == -1) {
            this.addModuleClass(local, rootObject, thisFolder, resource);
        } else if (bn.startsWith("applicationContext") && bn.endsWith(".xml")) {
            this.addModuleContext(local, rootObject, thisFolder, resource);
        } else if (bn.startsWith("messages") && (bn.endsWith(".xml") || bn.endsWith(".properties"))) {
            this.addModuleMessage(local, rootObject, thisFolder, resource);
        }
    }

    private void addModuleContext(Local local, FileObject rootObject, FileObject thisFolder, FileObject resource) throws IOException {
        ModuleResource moduleInfo = local.moduleResourceMap.get(thisFolder);
        moduleInfo.addContextResource(resource.getURL());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("module '" + moduleInfo.getMappingPath() + "': found context file, url=" + resource.getURL()));
        }
    }

    private void addModuleMessage(Local local, FileObject rootObject, FileObject thisFolder, FileObject resource) throws IOException {
        ModuleResource moduleInfo = local.moduleResourceMap.get(thisFolder);
        String directory = resource.getParent().getURL().toString();
        String messageFileName = resource.getName().getBaseName();
        String msgBasename = messageFileName.indexOf(95) == -1 ? messageFileName.substring(0, messageFileName.indexOf(46)) : messageFileName.substring(0, messageFileName.indexOf(95));
        moduleInfo.addMessageResource(directory + msgBasename);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("module '" + moduleInfo.getMappingPath() + "': found messages file, url=" + resource.getURL()));
        }
    }

    private void addModuleClass(Local local, FileObject rootObject, FileObject thisFolder, FileObject resource) throws IOException {
        String className = rootObject.getName().getRelativeName(resource.getName());
        Assert.isTrue((!className.startsWith("/") ? 1 : 0) != 0);
        className = StringUtils.removeEnd((String)className, (String)".class");
        className = className.replace('/', '.');
        ModuleResource module = local.moduleResourceMap.get(thisFolder);
        try {
            module.addModuleClass(Class.forName(className));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("module '" + module.getMappingPath() + "': found class, name=" + className));
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)"", (Throwable)e);
        }
    }

    protected void afterScanning(Local local) {
        for (ModuleResource moduleResource : local.moduleResourceMap.values()) {
            if (moduleResource.getContextResources().size() != 0 || moduleResource.getModuleClasses().size() != 0) continue;
            local.moduleResourceList.remove(moduleResource);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("remove empty module '" + moduleResource.getMappingPath() + "' " + moduleResource.getModuleUrl()));
        }
    }

    class Local {
        List<ModuleResource> moduleResourceList = new LinkedList<ModuleResource>();
        Map<FileObject, ModuleResource> moduleResourceMap = new HashMap<FileObject, ModuleResource>();

        Local() {
        }
    }
}

