/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.scanner;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class ModuleResource
implements Comparable<ModuleResource> {
    private URL moduleUrl;
    private String relativePath;
    private String mappingPath;
    private List<URL> contextResources = new LinkedList<URL>();
    private List<String> messageBasenames = new LinkedList<String>();
    private List<Class<?>> moduleClasses = new LinkedList();
    private ModuleResource parent;
    private String[] interceptedAllow;
    private String[] interceptedDeny;

    public URL getModuleUrl() {
        return this.moduleUrl;
    }

    public void setModuleUrl(URL moduleUrl) {
        this.moduleUrl = moduleUrl;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public ModuleResource getParent() {
        return this.parent;
    }

    public void setParent(ModuleResource parent) {
        this.parent = parent;
    }

    public String getMappingPath() {
        return this.mappingPath;
    }

    public void setMappingPath(String mappingPath) {
        this.mappingPath = mappingPath;
    }

    public List<URL> getContextResources() {
        return this.contextResources;
    }

    public void addContextResource(URL contextResource) {
        this.contextResources.add(contextResource);
    }

    public String[] getMessageBasenames() {
        return this.messageBasenames.toArray(new String[this.messageBasenames.size()]);
    }

    public void addMessageResource(String messageBasename) {
        this.messageBasenames.add(messageBasename);
    }

    public List<Class<?>> getModuleClasses() {
        return this.moduleClasses;
    }

    public void addModuleClass(Class<?> moduleClass) {
        this.moduleClasses.add(moduleClass);
    }

    public String[] getInterceptedAllow() {
        return this.interceptedAllow;
    }

    public void setInterceptedAllow(String[] interceptedAllow) {
        this.interceptedAllow = interceptedAllow;
    }

    public String[] getInterceptedDeny() {
        return this.interceptedDeny;
    }

    public void setInterceptedDeny(String[] interceptedDeny) {
        this.interceptedDeny = interceptedDeny;
    }

    @Override
    public int compareTo(ModuleResource o) {
        return this.moduleUrl.toString().length() - o.moduleUrl.toString().length();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleResource)) {
            return false;
        }
        return this.moduleUrl.equals(((ModuleResource)obj).moduleUrl);
    }

    public int hashCode() {
        return this.moduleUrl.hashCode() * 13;
    }

    public String toString() {
        return "ModuleResource[" + this.mappingPath + "=" + this.moduleUrl + "] " + "size of (class, ctx, messagesBasename) = (" + this.moduleClasses.size() + ", " + this.contextResources.size() + ", " + this.messageBasenames.size() + ")";
    }
}

