/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.RoseVersion;
import net.paoding.rose.load.LoadScope;
import net.paoding.rose.load.context.RoseWebAppContext;
import net.paoding.rose.scanner.ModuleResource;
import net.paoding.rose.scanner.ModuleResourceProvider;
import net.paoding.rose.scanner.ModuleResourceProviderImpl;
import net.paoding.rose.util.PrinteHelper;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.annotation.ReqMethod;
import net.paoding.rose.web.impl.mapping.ConstantMapping;
import net.paoding.rose.web.impl.mapping.MappingNode;
import net.paoding.rose.web.impl.mapping.TreeBuilder;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPath;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPathEnds;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPathEquals;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPathRegexMatch;
import net.paoding.rose.web.impl.mapping.ignored.IgnoredPathStarts;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.module.ModulesBuilder;
import net.paoding.rose.web.impl.module.ModulesBuilderImpl;
import net.paoding.rose.web.impl.thread.LinkedEngine;
import net.paoding.rose.web.impl.thread.RootEngine;
import net.paoding.rose.web.impl.thread.Rose;
import net.paoding.rose.web.instruction.InstructionExecutor;
import net.paoding.rose.web.instruction.InstructionExecutorImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.util.NestedServletException;

public class RoseFilter
extends GenericFilterBean {
    private static final String ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE = WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE;
    private String contextConfigLocation;
    private InstructionExecutor instructionExecutor = new InstructionExecutorImpl();
    private List<Module> modules;
    private MappingNode mappingTree;
    private Class<? extends ModuleResourceProvider> moduleResourceProviderClass = ModuleResourceProviderImpl.class;
    private Class<? extends ModulesBuilder> modulesBuilderClass = ModulesBuilderImpl.class;
    private LoadScope load = new LoadScope("", "controllers");
    private IgnoredPath[] ignoredPaths = new IgnoredPath[]{new IgnoredPathStarts("/views/"), new IgnoredPathEquals("/favicon.ico")};

    public void setContextConfigLocation(String contextConfigLocation) {
        if (StringUtils.isBlank((String)contextConfigLocation)) {
            throw new IllegalArgumentException("contextConfigLocation");
        }
        this.contextConfigLocation = contextConfigLocation;
    }

    public void setInstructionExecutor(InstructionExecutor instructionExecutor) {
        this.instructionExecutor = instructionExecutor;
    }

    public void setModuleResourceProviderClass(Class<? extends ModuleResourceProvider> moduleResourceProviderClass) {
        this.moduleResourceProviderClass = moduleResourceProviderClass;
    }

    public void setModulesBuilderClass(Class<? extends ModulesBuilder> modulesBuilderClass) {
        this.modulesBuilderClass = modulesBuilderClass;
    }

    public void setLoad(String load) {
        this.load = new LoadScope(load, "controllers");
    }

    public void setIgnoredPaths(String[] ignoredPathStrings) {
        ArrayList<IgnoredPath> list = new ArrayList<IgnoredPath>(ignoredPathStrings.length + 2);
        for (String ignoredPath : ignoredPathStrings) {
            if (StringUtils.isEmpty((String)(ignoredPath = ignoredPath.trim()))) continue;
            if (ignoredPath.equals("*")) {
                list.add(new IgnoredPathEquals(""));
                list.add(new IgnoredPathStarts("/"));
                break;
            }
            if (ignoredPath.startsWith("regex:")) {
                list.add(new IgnoredPathRegexMatch(ignoredPath.substring("regex:".length())));
                continue;
            }
            if (ignoredPath.length() > 0 && !ignoredPath.startsWith("/") && !ignoredPath.startsWith("*")) {
                ignoredPath = "/" + ignoredPath;
            }
            if (ignoredPath.endsWith("*")) {
                list.add(new IgnoredPathStarts(ignoredPath.substring(0, ignoredPath.length() - 1)));
                continue;
            }
            if (ignoredPath.startsWith("*")) {
                list.add(new IgnoredPathEnds(ignoredPath.substring(1)));
                continue;
            }
            list.add(new IgnoredPathEquals(ignoredPath));
        }
        IgnoredPath[] ignoredPaths = Arrays.copyOf(this.ignoredPaths, this.ignoredPaths.length + list.size());
        for (int i = this.ignoredPaths.length; i < ignoredPaths.length; ++i) {
            ignoredPaths[i] = (IgnoredPath)list.get(i - this.ignoredPaths.length);
        }
        this.ignoredPaths = ignoredPaths;
    }

    protected final void initFilterBean() throws ServletException {
        try {
            long startTime = System.currentTimeMillis();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"[init] call 'init/rootContext'");
            }
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                Enumeration iter = this.getFilterConfig().getInitParameterNames();
                while (iter.hasMoreElements()) {
                    String name = (String)iter.nextElement();
                    sb.append(name).append("='").append(this.getFilterConfig().getInitParameter(name)).append("'\n");
                }
                this.logger.debug((Object)("[init] parameters: " + sb));
            }
            WebApplicationContext rootContext = this.prepareRootApplicationContext();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"[init] exits from 'init/rootContext'");
                this.logger.info((Object)"[init] call 'init/module'");
            }
            this.modules = this.prepareModules(rootContext);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"[init] exits from 'init/module'");
                this.logger.info((Object)"[init] call 'init/mappingTree'");
            }
            this.mappingTree = this.prepareMappingTree(this.modules);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"[init] exits from 'init/mappingTree'");
                this.logger.info((Object)"[init] exits from 'init'");
            }
            long endTime = System.currentTimeMillis();
            this.printRoseInfos(endTime - startTime);
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("[Rose-").append(RoseVersion.getVersion());
            sb.append("@Spring-").append(SpringVersion.getVersion()).append("]:");
            sb.append(e.getMessage());
            this.logger.error((Object)sb.toString(), e);
            throw new NestedServletException(sb.toString(), e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.logger.isDebugEnabled()) {
            StringBuffer sb = httpRequest.getRequestURL();
            String query = httpRequest.getQueryString();
            if (query != null && query.length() > 0) {
                sb.append("?").append(query);
            }
            this.logger.debug((Object)(httpRequest.getMethod() + " " + sb.toString()));
        }
        this.supportsRosepipe(httpRequest);
        RequestPath requestPath = new RequestPath(httpRequest);
        if (this.quicklyPass(requestPath)) {
            this.notMatched(filterChain, httpRequest, httpResponse, requestPath);
            return;
        }
        boolean matched = false;
        try {
            Rose rose = new Rose(this.modules, this.mappingTree, httpRequest, httpResponse, requestPath);
            matched = rose.start();
        }
        catch (Throwable exception) {
            this.throwServletException(requestPath, exception);
        }
        if (!matched) {
            this.notMatched(filterChain, httpRequest, httpResponse, requestPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void supportsRosepipe(HttpServletRequest httpRequest) {
        Object window = httpRequest.getAttribute("$$paoding-rose-portal.window");
        if (window != null && window.getClass().getName().startsWith("net.paoding.rose.web.portal")) {
            httpRequest.setAttribute("$$paoding-rose-portal.window.in", (Object)Boolean.TRUE);
            if (this.logger.isDebugEnabled()) {
                try {
                    this.logger.debug((Object)("notify window '" + httpRequest.getAttribute("$$paoding-rose-portal.window.name") + "'"));
                }
                catch (Exception e) {
                    this.logger.error((Object)"", (Throwable)e);
                }
            }
            Object object = window;
            synchronized (object) {
                window.notifyAll();
            }
        }
    }

    private WebApplicationContext prepareRootApplicationContext() throws IOException {
        ApplicationContext oldRootContext;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[init/rootContext] starting ...");
        }
        if ((oldRootContext = (ApplicationContext)this.getServletContext().getAttribute(ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE)) != null) {
            if (oldRootContext.getClass() != RoseWebAppContext.class) {
                throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ContextLoader* definitions in your web.xml!");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("[init/rootContext] the root context exists:" + oldRootContext));
            }
            return (RoseWebAppContext)oldRootContext;
        }
        RoseWebAppContext rootContext = new RoseWebAppContext(this.getServletContext(), this.load, false);
        String contextConfigLocation = this.contextConfigLocation;
        if (StringUtils.isBlank((String)contextConfigLocation)) {
            String webxmlContextConfigLocation = this.getServletContext().getInitParameter("contextConfigLocation");
            contextConfigLocation = StringUtils.isBlank((String)webxmlContextConfigLocation) ? "/WEB-INF/applicationContext*.xml" : webxmlContextConfigLocation;
        }
        rootContext.setConfigLocation(contextConfigLocation);
        rootContext.setId("rose.root");
        rootContext.refresh();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[init/rootContext] exits");
        }
        this.getServletContext().setAttribute(ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)rootContext);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("[init/rootContext] Published rose.root WebApplicationContext [" + rootContext + "] as ServletContext attribute with name [" + ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
        }
        return rootContext;
    }

    private List<Module> prepareModules(WebApplicationContext rootContext) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[init/mudule] starting ...");
        }
        ModuleResourceProvider provider = this.moduleResourceProviderClass.newInstance();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("[init/module] using provider: " + provider));
            this.logger.info((Object)"[init/module] call 'moduleResource': to find all module resources.");
            this.logger.info((Object)("[init/module] load " + this.load));
        }
        List<ModuleResource> moduleResources = provider.findModuleResources(this.load);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[init/mudule] exits 'moduleResource'");
        }
        ModulesBuilder modulesBuilder = this.modulesBuilderClass.newInstance();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("[init/module] using modulesBuilder: " + modulesBuilder));
            this.logger.info((Object)"[init/module] call 'moduleBuild': to build modules.");
        }
        List<Module> modules = modulesBuilder.build(moduleResources, rootContext);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[init/module] exits from 'moduleBuild'");
            this.logger.info((Object)("[init/mudule] found " + modules.size() + " modules."));
        }
        return modules;
    }

    private MappingNode prepareMappingTree(List<Module> modules) {
        ConstantMapping rootMapping = new ConstantMapping("");
        MappingNode mappingTree = new MappingNode(rootMapping);
        LinkedEngine rootEngine = new LinkedEngine(null, new RootEngine(this.instructionExecutor), mappingTree);
        mappingTree.getMiddleEngines().addEngine(ReqMethod.ALL, rootEngine);
        TreeBuilder treeBuilder = new TreeBuilder();
        treeBuilder.create(mappingTree, modules);
        return mappingTree;
    }

    private boolean quicklyPass(RequestPath requestPath) {
        for (IgnoredPath p : this.ignoredPaths) {
            if (!p.hit(requestPath)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        WebApplicationContext rootContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (rootContext != null) {
            try {
                if (rootContext instanceof AbstractApplicationContext) {
                    ((AbstractApplicationContext)rootContext).close();
                }
            }
            catch (Throwable e) {
                this.logger.error((Object)"", e);
                this.getServletContext().log("", e);
            }
        }
        try {
            this.mappingTree.destroy();
        }
        catch (Throwable e) {
            this.logger.error((Object)"", e);
            this.getServletContext().log("", e);
        }
        super.destroy();
    }

    protected void notMatched(FilterChain filterChain, HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestPath path) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("not rose uri: " + path.getUri()));
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private void throwServletException(RequestPath requestPath, Throwable exception) throws ServletException {
        String msg = (Object)((Object)requestPath.getMethod()) + " " + requestPath.getUri();
        Object servletException = exception instanceof ServletException ? (ServletException)exception : new NestedServletException(msg, exception);
        this.logger.error((Object)msg, exception);
        this.getServletContext().log(msg, exception);
        throw servletException;
    }

    private void printRoseInfos(long initTimeCost) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)PrinteHelper.dumpModules(this.modules));
            this.logger.debug((Object)("mapping tree:\n" + PrinteHelper.list(this.mappingTree)));
        }
        String msg = String.format("[init] rose initialized, %s modules loaded, cost %sms! (version=%s)", this.modules.size(), initTimeCost, RoseVersion.getVersion());
        this.logger.info((Object)msg);
        this.getServletContext().log(msg);
    }
}

