/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.paoding.rose.web.portal.impl.PortalRequest;
import net.paoding.rose.web.portal.impl.WindowImpl;
import net.paoding.rose.web.portal.impl.WindowRequest;
import net.paoding.rose.web.portal.impl.WindowResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class WindowTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(WindowTask.class);
    private final WindowImpl window;
    private final WindowRequest request;
    private final WindowResponse response;

    public WindowTask(WindowImpl window, WindowRequest request, WindowResponse response) {
        if (window == null) {
            throw new NullPointerException("window");
        }
        this.window = window;
        this.request = request;
        this.response = response;
    }

    public WindowImpl getWindow() {
        return this.window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.window.getContainer().onWindowStarted(this.window);
            String windowPath = this.window.getPath();
            if (windowPath.length() == 0 || windowPath.charAt(0) != '/') {
                String requestUri = this.request.getRequestURI();
                if (!requestUri.endsWith("/")) {
                    requestUri = requestUri + "/";
                }
                windowPath = requestUri + windowPath;
            }
            RequestDispatcher rd = this.request.getRequestDispatcher(windowPath);
            this.request.setAttribute("$$paoding-rose-portal.window", this.window);
            if (this.response.isCommitted()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("onWindowTimeout: response has committed. [" + this.window.getName() + "]@" + this.window.getContainer()));
                }
                this.window.getContainer().onWindowTimeout(this.window);
                return;
            }
            rd.forward((ServletRequest)this.request, (ServletResponse)this.response);
            this.window.getContainer().onWindowDone(this.window);
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
            this.window.setThrowable(e);
            this.window.getContainer().onWindowError(this.window);
        }
        finally {
            HttpServletRequest wrapper = this.window.getContainer().getRequest();
            PortalRequest portalRequest = PortalRequest.unwrapPortalRequest(wrapper);
            portalRequest.setRequest(null);
        }
    }

    public String toString() {
        return "window [name=" + this.window.getName() + ", path=" + this.window.getPath() + "]";
    }
}

