/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponseWrapper;
import net.paoding.rose.web.portal.Window;
import net.paoding.rose.web.portal.impl.GenericWindowContainer;
import net.paoding.rose.web.portal.impl.WindowImpl;

class WindowResponse
extends HttpServletResponseWrapper {
    private WindowImpl window;
    private PrintWriter writer;
    private ServletOutputStream out;
    private Locale locale;
    private String charset;

    public WindowResponse(WindowImpl window) {
        super(window.getContainer().getResponse());
        this.window = window;
    }

    public Window getWindow() {
        return this.window;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new ServletOutputStream(){
                ByteArrayOutputStream baos;
                {
                    this.baos = new ByteArrayOutputStream(WindowResponse.this.getBufferSize());
                }

                public void write(int b) throws IOException {
                    this.baos.write(b);
                }

                public void flush() throws IOException {
                    byte[] bytes = this.baos.toByteArray();
                    this.baos.reset();
                    WindowResponse.this.window.appendContent(new String(bytes, WindowResponse.this.getCharacterEncoding()));
                }
            };
        }
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new Writer(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void write(char[] cbuf, int offset, int len) throws IOException {
                    WindowResponse.this.window.appendContent(cbuf, offset, len);
                }
            });
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String name, String value) {
        GenericWindowContainer genericWindowContainer = this.window.getContainer();
        synchronized (genericWindowContainer) {
            super.setHeader(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        GenericWindowContainer genericWindowContainer = this.window.getContainer();
        synchronized (genericWindowContainer) {
            super.addHeader(name, value);
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : super.getLocale();
    }

    public void sendError(int sc) throws IOException {
        this.window.setStatus(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.window.setStatus(sc, msg);
    }

    public void setStatus(int sc) {
        this.window.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this.window.setStatus(sc, sm);
    }

    public void sendRedirect(String location) throws IOException {
        throw new UnsupportedOperationException("don't call sendRedirect in window request:" + location);
    }

    public void setBufferSize(int size) {
    }

    public void resetBuffer() {
    }

    public void setCharacterEncoding(String charset) {
        this.charset = charset;
    }

    public String getCharacterEncoding() {
        return this.charset != null ? this.charset : super.getCharacterEncoding();
    }

    public void setContentType(String type) {
    }

    public void setContentLength(int len) {
    }
}

