/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import net.paoding.rose.web.portal.Window;
import net.paoding.rose.web.portal.impl.SessionAfterCommitted;
import net.paoding.rose.web.portal.util.Enumerator;

class WindowRequest
extends HttpServletRequestWrapper {
    private static final String HEAER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HEAER_IF_NONE_MATHC = "If-None-Match";
    private final Window window;
    private Set<String> deleteAttributes;
    private Object mutex = this;

    public WindowRequest(Window window, HttpServletRequest request) {
        super(request);
        this.window = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Object value = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.deleteAttributes != null && this.deleteAttributes.contains(name)) {
                return null;
            }
            value = this.window.get(name);
            if (value == null) {
                value = super.getAttribute(name);
            }
        }
        return value;
    }

    public String getHeader(String name) {
        if (this.isDisabledHeader(name)) {
            return null;
        }
        return super.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        if (this.isDisabledHeader(name)) {
            return null;
        }
        return super.getHeaders(name);
    }

    private boolean isDisabledHeader(String headerName) {
        return HEAER_IF_MODIFIED_SINCE.equals(headerName) || HEAER_IF_NONE_MATHC.equals(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashSet<String> keys;
        Object object = this.mutex;
        synchronized (object) {
            keys = new HashSet<String>(this.window.getAttributes().keySet());
            Enumeration names = super.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (this.deleteAttributes != null && this.deleteAttributes.contains(name)) continue;
                keys.add(name);
            }
        }
        return new Enumerator<String>(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("don't set a NULL named attribute");
        }
        Object object = this.mutex;
        synchronized (object) {
            this.window.remove(name);
            if (this.deleteAttributes == null) {
                this.deleteAttributes = new HashSet<String>(4);
                this.deleteAttributes.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("don't set a NULL named attribute");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.window.set(name, value);
            if (this.deleteAttributes != null) {
                this.deleteAttributes.remove(name);
            }
        }
    }

    public Map<String, Object> getPrivateAttributes() {
        return this.window.getAttributes();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(false);
        if (session != null) {
            return session;
        }
        if (create) {
            if (this.window.getContainer().getInvocation().getResponse().isCommitted()) {
                session = new SessionAfterCommitted(new IllegalStateException("Cannot create a session after the response has been committed"));
            } else {
                try {
                    session = super.getSession(true);
                }
                catch (IllegalStateException e) {
                    session = new SessionAfterCommitted(e);
                }
            }
        }
        return session;
    }
}

