/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import net.paoding.rose.web.portal.Portal;
import net.paoding.rose.web.portal.Window;
import net.paoding.rose.web.portal.impl.GenericWindowContainer;
import net.paoding.rose.web.portal.impl.WindowFuture;

class WindowImpl
implements Window {
    private static boolean defaultMayInterruptIfRunning;
    private String name;
    private String path;
    private StringBuilder buffer;
    private Throwable throwable;
    private int statusCode = 200;
    private String statusMessage = "";
    private GenericWindowContainer container;
    private WindowFuture<?> future;
    private boolean mayInterruptIfRunning = defaultMayInterruptIfRunning;
    private boolean interrupted = false;
    private Map<String, Object> privateAttributes;

    public WindowImpl(GenericWindowContainer container, String name, String windowPath) {
        this.container = container;
        this.name = name;
        this.path = windowPath;
    }

    @Override
    @Deprecated
    public Portal getPortal() {
        return (Portal)((Object)this.container);
    }

    @Override
    public GenericWindowContainer getContainer() {
        return this.container;
    }

    @Override
    public Future<?> getFuture() {
        return this.future;
    }

    public void setFuture(WindowFuture<?> future) {
        this.future = future;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    @Override
    public boolean isCancelled() {
        return this.interrupted || this.future.isCancelRequested() || this.future.isCancelled();
    }

    @Override
    public void set(String key, Object value) {
        if ("_future.cancel.enable_".equals(key)) {
            if (value == null || Boolean.FALSE.equals(value) || "false".equals(value)) {
                this.setMayInterruptIfRunning(false);
            } else {
                this.setMayInterruptIfRunning(true);
            }
        } else {
            if (this.privateAttributes == null) {
                this.privateAttributes = new HashMap<String, Object>();
            }
            this.privateAttributes.put(key, value);
        }
    }

    @Override
    public Object get(String key) {
        if ("_future.cancel.enable_".equals(key)) {
            return this.mayInterruptIfRunning();
        }
        return this.privateAttributes == null ? null : this.privateAttributes.get(key);
    }

    @Override
    public void remove(String key) {
        if ("_future.cancel.enable_".equals(key)) {
            this.setMayInterruptIfRunning(defaultMayInterruptIfRunning);
            return;
        }
        if (this.privateAttributes != null) {
            this.privateAttributes.remove(key);
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.privateAttributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.privateAttributes);
    }

    @Override
    public void setTitle(Object title) {
        this.set("_title_", title);
    }

    @Override
    public Object getTitle() {
        Object value = this.get("_title_");
        if (value == null) {
            value = this.name;
        }
        return value;
    }

    @Override
    public int getContentLength() {
        return this.buffer == null ? -1 : this.buffer.length();
    }

    @Override
    public String getContent() {
        return this.buffer == null ? "" : this.buffer.toString();
    }

    @Override
    public void clearContent() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
    }

    void appendContent(String content) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        this.buffer.append(content);
    }

    void appendContent(CharSequence content) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        this.buffer.append(content);
    }

    void appendContent(char[] content) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        this.buffer.append(content);
    }

    void appendContent(char[] content, int offset, int len) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        this.buffer.append(content, offset, len);
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public boolean isSuccess() {
        return !this.isCancelled() && this.isDone() && this.getStatusCode() == 200 && this.throwable == null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.statusMessage = throwable.getMessage();
        if (this.statusCode < 500 || this.statusCode >= 600) {
            this.statusCode = 500;
        }
    }

    public void setStatus(int sc) {
        this.statusCode = sc;
        this.statusMessage = "";
    }

    public void setStatus(int sc, String msg) {
        this.statusCode = sc;
        this.statusMessage = msg;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public String toString() {
        return "window[" + this.path + "]";
    }

    @Override
    public void render(Writer out) throws IOException {
        this.getContainer().render(out, this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Window)) {
            return false;
        }
        return this.name.equals(((Window)obj).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void setMayInterruptIfRunning(boolean mayInterruptIfRunning) {
        this.mayInterruptIfRunning = mayInterruptIfRunning;
    }

    @Override
    public boolean mayInterruptIfRunning() {
        return this.mayInterruptIfRunning;
    }

    static {
        String pv;
        defaultMayInterruptIfRunning = false;
        try {
            pv = System.getProperty("rose.portal.may_interrupt_if_running");
            if (pv == null) {
                pv = System.getenv("rose.portal.may_interrupt_if_running");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pv = "false";
        }
        if (pv == null) {
            pv = "false";
        }
        defaultMayInterruptIfRunning = Boolean.valueOf(pv);
    }
}

