/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.paoding.rose.web.portal.impl.WindowImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class WindowFuture<T>
implements Future<T> {
    private static Log logger = LogFactory.getLog(WindowFuture.class);
    private final Future<T> future;
    private final WindowImpl window;
    private boolean cancelRequested = false;

    public WindowFuture(Future<T> future, WindowImpl window) {
        this.future = future;
        this.window = window;
    }

    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelRequested = true;
        if (!mayInterruptIfRunning) {
            return this.cancel0(mayInterruptIfRunning);
        }
        if (this.window.mayInterruptIfRunning()) {
            return this.cancel0(mayInterruptIfRunning);
        }
        return this.cancel0(false);
    }

    private boolean cancel0(boolean mayInterruptIfRunning) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("canceling inner future: " + this.window.getName() + "  mayInterruptIfRunning=" + mayInterruptIfRunning));
        }
        if (this.future.cancel(mayInterruptIfRunning)) {
            this.window.getContainer().onWindowCanceled(this.window);
            return true;
        }
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    public Future<T> getInnerFuture() {
        return this.future;
    }
}

