/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.paoding.rose.web.ControllerInterceptorAdapter;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.portal.Portal;
import net.paoding.rose.web.portal.PortalUtils;
import net.paoding.rose.web.portal.Window;
import net.paoding.rose.web.portal.impl.PortalImpl;

public class PortalWaitInterceptor
extends ControllerInterceptorAdapter {
    protected boolean isForAction(Method actionMethod, Class<?> controllerClazz) {
        for (Class<?> paramType : actionMethod.getParameterTypes()) {
            if (paramType != Portal.class) continue;
            return true;
        }
        return false;
    }

    public Object after(Invocation inv, Object instruction) throws Exception {
        long deadline;
        PortalImpl portal = (PortalImpl)PortalUtils.getPortal(inv);
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug((Object)(portal + " is going to wait windows."));
        }
        PortalImpl listener = portal;
        long begin = System.currentTimeMillis();
        if (portal.getTimeout() > 0L) {
            deadline = begin + portal.getTimeout();
            if (debugEnabled) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
                this.logger.debug((Object)(portal + ".maxWait=" + portal.getTimeout() + "; deadline=" + sdf.format(new Date(deadline))));
            }
        } else {
            deadline = 0L;
            if (debugEnabled) {
                this.logger.debug((Object)(portal + ".maxWait=(forever)"));
            }
        }
        int winSize = portal.getWindows().size();
        int winIndex = 0;
        List<Window> windows = portal.getWindows();
        for (Window window : windows) {
            ++winIndex;
            Future<?> future = window.getFuture();
            if (future.isDone()) {
                if (!debugEnabled) continue;
                if (future.isCancelled()) {
                    this.logger.debug((Object)("[" + winIndex + "/" + winSize + "] continue[cancelled]: " + window.getName()));
                }
                if (!future.isDone()) continue;
                this.logger.debug((Object)("[" + winIndex + "/" + winSize + "] continue[done]: " + window.getName()));
                continue;
            }
            long awaitTime = 0L;
            try {
                long begineWait = System.currentTimeMillis();
                if (deadline > 0L) {
                    awaitTime = deadline - begineWait;
                    if (awaitTime > 0L) {
                        if (debugEnabled) {
                            this.logger.debug((Object)("[" + winIndex + "/" + winSize + "] waiting[begin]: " + window.getName() + "; maxWait=" + awaitTime));
                        }
                        future.get(awaitTime, TimeUnit.MILLISECONDS);
                        if (!debugEnabled) continue;
                        this.logger.debug((Object)("[" + winIndex + "/" + winSize + "] waiting[done]: " + window.getName() + "; actualWait=" + (System.currentTimeMillis() - begineWait)));
                        continue;
                    }
                    this.logger.error((Object)("[" + winIndex + "/" + winSize + "] waiting[been timeout now]: " + window.getName()));
                    listener.onWindowTimeout(window);
                    future.cancel(true);
                    continue;
                }
                if (debugEnabled) {
                    this.logger.debug((Object)("[" + winIndex + "/" + winSize + "] waiting[begin]: " + window.getName() + "; maxWait=(forever)"));
                }
                future.get();
                if (!debugEnabled) continue;
                this.logger.debug((Object)("[" + winIndex + "/" + winSize + "] waiting[done]: " + window.getName() + "; actualWait=" + (System.currentTimeMillis() - begineWait)));
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("x[" + winIndex + "/" + winSize + "] waiting[interrupted]: " + window.getName()));
            }
            catch (ExecutionException e) {
                this.logger.error((Object)("x[" + winIndex + "/" + winSize + "] waiting[error]: " + window.getName()), (Throwable)e);
                window.setThrowable(e);
                listener.onWindowError(window);
            }
            catch (TimeoutException e) {
                this.logger.error((Object)("x[" + winIndex + "/" + winSize + "] waiting[timeout]: " + window.getName()), (Throwable)e);
                listener.onWindowTimeout(window);
                future.cancel(true);
            }
        }
        if (debugEnabled) {
            this.logger.debug((Object)("[" + winIndex + "/" + winSize + "] size of simple windows = " + winIndex));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(portal + ".waitForWindows is done; cost=" + (System.currentTimeMillis() - begin)));
        }
        return instruction;
    }
}

