/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import net.paoding.rose.web.portal.Portal;
import net.paoding.rose.web.portal.impl.PrivateRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class PortalRequest
extends HttpServletRequestWrapper
implements HttpServletRequest {
    private static final Log logger = LogFactory.getLog(PortalRequest.class);
    private Portal portal;
    private HttpServletRequest orginal;
    private ThreadLocal<HttpServletRequest> threadLocalRequests = new ThreadLocal();

    public static PortalRequest unwrapPortalRequest(HttpServletRequest request) {
        while (true) {
            if (request instanceof PortalRequest) {
                return (PortalRequest)request;
            }
            if (!(request instanceof HttpServletRequestWrapper)) break;
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public PortalRequest(Portal portal, HttpServletRequest orginal) {
        super((HttpServletRequest)new PrivateRequestWrapper(orginal));
        this.portal = portal;
        this.orginal = orginal;
    }

    public void setRequest(ServletRequest request) {
        if (request != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("set request: %s", request));
            }
            this.threadLocalRequests.set((HttpServletRequest)request);
        } else {
            if (logger.isDebugEnabled()) {
                HttpServletRequest tmpRequest = this.threadLocalRequests.get();
                logger.debug((Object)String.format("remove request: %s", tmpRequest));
            }
            this.threadLocalRequests.remove();
        }
    }

    public HttpServletRequest getRequest() {
        HttpServletRequest request = this.threadLocalRequests.get();
        return request == null ? this.orginal : request;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.getRequest().getRequestDispatcher(path);
    }

    public Object getAttribute(String name) {
        return this.getRequest().getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.getRequest().getAttributeNames();
    }

    public void removeAttribute(String name) {
        this.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.getRequest().setAttribute(name, value);
    }

    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    public String getQueryString() {
        return this.getRequest().getQueryString();
    }

    public String getRequestURI() {
        return this.getRequest().getRequestURI();
    }

    public String getServletPath() {
        return this.getRequest().getServletPath();
    }

    public StringBuffer getRequestURL() {
        return this.getRequest().getRequestURL();
    }

    public String getAuthType() {
        return this.getRequest().getAuthType();
    }

    public Cookie[] getCookies() {
        return this.getRequest().getCookies();
    }

    public long getDateHeader(String name) {
        return this.getRequest().getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.getRequest().getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.getRequest().getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.getRequest().getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.getRequest().getIntHeader(name);
    }

    public String getMethod() {
        return this.getRequest().getMethod();
    }

    public String getPathInfo() {
        return this.getRequest().getPathInfo();
    }

    public String getPathTranslated() {
        return this.getRequest().getPathTranslated();
    }

    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.getRequest().getRequestedSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(boolean create) {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getSession(create);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession() {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getSession();
        }
    }

    public boolean isRequestedSessionIdValid() {
        return this.getRequest().isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getRequest().isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getRequest().isRequestedSessionIdFromURL();
    }

    public synchronized boolean isRequestedSessionIdFromUrl() {
        return this.getRequest().isRequestedSessionIdFromUrl();
    }

    public String getCharacterEncoding() {
        return this.getRequest().getCharacterEncoding();
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this.getRequest().setCharacterEncoding(enc);
    }

    public int getContentLength() {
        return this.getRequest().getContentLength();
    }

    public String getContentType() {
        return this.getRequest().getContentType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletInputStream getInputStream() throws IOException {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getInputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String name) {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getParameter(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getParameterMap() {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getParameterMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getParameterNames() {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getParameterNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParameterValues(String name) {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getParameterValues(name);
        }
    }

    public String getProtocol() {
        return this.getRequest().getProtocol();
    }

    public String getScheme() {
        return this.getRequest().getScheme();
    }

    public String getServerName() {
        return this.getRequest().getServerName();
    }

    public int getServerPort() {
        return this.getRequest().getServerPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedReader getReader() throws IOException {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getReader();
        }
    }

    public String getRemoteAddr() {
        return this.getRequest().getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.getRequest().getRemoteHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getLocale() {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getLocale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getLocales() {
        Portal portal = this.portal;
        synchronized (portal) {
            return this.getRequest().getLocales();
        }
    }

    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    public String getRealPath(String path) {
        return this.getRequest().getRealPath(path);
    }

    public int getRemotePort() {
        return this.getRequest().getRemotePort();
    }

    public String getLocalName() {
        return this.getRequest().getLocalName();
    }

    public String getLocalAddr() {
        return this.getRequest().getLocalAddr();
    }

    public int getLocalPort() {
        return this.getRequest().getLocalPort();
    }

    public String toString() {
        return "PortalRequest for " + this.portal.getRequest().getRequestURI();
    }
}

