/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.util.concurrent.ExecutorService;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.impl.thread.InvocationBean;
import net.paoding.rose.web.portal.Pipe;
import net.paoding.rose.web.portal.Portal;
import net.paoding.rose.web.portal.PortalFactory;
import net.paoding.rose.web.portal.PortalSetting;
import net.paoding.rose.web.portal.WindowListener;
import net.paoding.rose.web.portal.impl.PipeImpl;
import net.paoding.rose.web.portal.impl.PortalImpl;
import net.paoding.rose.web.portal.impl.PortalRequest;
import net.paoding.rose.web.portal.impl.PortalResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class PortalFactoryImpl
implements PortalFactory,
InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ExecutorService executorService;
    private WindowListener windowListener;

    public void setExecutorService(ExecutorService executor) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("using executorService: " + executor));
        }
        this.executorService = executor;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setWindowListener(WindowListener portalListener) {
        this.windowListener = portalListener;
    }

    public WindowListener getWindowListener() {
        return this.windowListener;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.windowListener);
        Assert.notNull((Object)this.executorService);
    }

    @Override
    public Portal createPortal(Invocation inv) {
        long annotationTimeout;
        PortalImpl portal = (PortalImpl)inv.getAttribute("$$paoding-rose-portal.portal");
        if (portal != null) {
            return portal;
        }
        portal = new PortalImpl(inv, this.executorService, this.windowListener);
        long timeout = 0L;
        PortalSetting portalSetting = inv.getMethod().getAnnotation(PortalSetting.class);
        if (portalSetting != null && portalSetting.timeout() >= 0L && (annotationTimeout = portalSetting.timeUnit().toMillis(portalSetting.timeout())) >= 0L) {
            timeout = annotationTimeout;
        }
        if (timeout > 0L) {
            portal.setTimeout(timeout);
        }
        HttpServletRequest innerRequest = inv.getRequest();
        HttpServletRequestWrapper requestWrapper = null;
        while (innerRequest instanceof HttpServletRequestWrapper) {
            requestWrapper = (HttpServletRequestWrapper)innerRequest;
            innerRequest = (HttpServletRequest)((HttpServletRequestWrapper)innerRequest).getRequest();
        }
        PortalRequest portalRequest = new PortalRequest(portal, innerRequest);
        if (requestWrapper == null) {
            inv.setRequest((HttpServletRequest)portalRequest);
        } else {
            requestWrapper.setRequest((ServletRequest)portalRequest);
        }
        HttpServletResponse innerResponse = inv.getResponse();
        HttpServletResponseWrapper responseWrapper = null;
        while (innerResponse instanceof HttpServletResponseWrapper) {
            responseWrapper = (HttpServletResponseWrapper)innerResponse;
            innerResponse = (HttpServletResponse)((HttpServletResponseWrapper)innerResponse).getResponse();
        }
        PortalResponse portalResponse = new PortalResponse(portal, innerResponse);
        if (responseWrapper == null) {
            ((InvocationBean)inv).setResponse((HttpServletResponse)portalResponse);
        } else {
            responseWrapper.setResponse((ServletResponse)portalResponse);
        }
        inv.setAttribute("$$paoding-rose-portal.portal", (Object)portal);
        return portal;
    }

    @Override
    public Pipe createPipe(Invocation inv, boolean create) {
        PipeImpl pipe = (PipeImpl)inv.getHeadInvocation().getAttribute("$$paoding-rose-portal.pipe");
        if (pipe == null) {
            if (create) {
                pipe = new PipeImpl(inv, this.executorService, this.windowListener);
                inv.getHeadInvocation().setAttribute("$$paoding-rose-portal.pipe", (Object)pipe);
            }
        } else if (pipe.getInvocation() != inv) {
            throw new UnsupportedOperationException("Pipe is only allowed in one place for a request, don't forward to path that using pipe. ");
        }
        return pipe;
    }
}

