/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.util.Arrays;
import java.util.List;
import net.paoding.rose.web.portal.WindowListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.context.WebApplicationContext;

public class PortalBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    public static final String PORTAL_EXECUTOR_CORE_POOL_SIZE = "portalExecutorCorePoolSize";
    public static final String PORTAL_EXECUTOR_MAX_POOL_SIZE = "portalExecutorMaxPoolSize";
    public static final String PORTAL_EXECUTOR_KEEP_ALIVE_SECONDS = "portalExecutorKeepAliveSeconds";
    public static final String PORTAL_LISTENERS = "portalListeners";
    private static Log logger = LogFactory.getLog(PortalBeanPostProcessor.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.applicationContext instanceof WebApplicationContext) {
            WebApplicationContext webApplicationContext = (WebApplicationContext)this.applicationContext;
            if (ThreadPoolTaskExecutor.class == bean.getClass()) {
                String paramKeepAliveSeconds;
                ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)bean;
                String paramCorePoolSize = webApplicationContext.getServletContext().getInitParameter(PORTAL_EXECUTOR_CORE_POOL_SIZE);
                if (StringUtils.isNotBlank((String)paramCorePoolSize)) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("found param portalExecutorCorePoolSize=" + paramCorePoolSize));
                    }
                } else {
                    throw new IllegalArgumentException("please add '<context-param><param-name>portalExecutorCorePoolSize</param-name><param-value>a number here</param-value></context-param>' in your web.xml");
                }
                executor.setCorePoolSize(Integer.parseInt(paramCorePoolSize));
                String paramMaxPoolSize = webApplicationContext.getServletContext().getInitParameter(PORTAL_EXECUTOR_MAX_POOL_SIZE);
                if (StringUtils.isNotBlank((String)paramMaxPoolSize)) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("found param portalExecutorMaxPoolSize=" + paramMaxPoolSize));
                    }
                    executor.setMaxPoolSize(Integer.parseInt(paramMaxPoolSize));
                }
                if (StringUtils.isNotBlank((String)(paramKeepAliveSeconds = webApplicationContext.getServletContext().getInitParameter(PORTAL_EXECUTOR_KEEP_ALIVE_SECONDS)))) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("found param portalExecutorKeepAliveSeconds=" + paramKeepAliveSeconds));
                    }
                    executor.setKeepAliveSeconds(Integer.parseInt(paramKeepAliveSeconds));
                }
            } else if (List.class.isInstance(bean) && "portalListenerList".equals(beanName)) {
                String paramListeners = webApplicationContext.getServletContext().getInitParameter(PORTAL_LISTENERS);
                List list = (List)bean;
                if (StringUtils.isNotBlank((String)paramListeners)) {
                    Object[] splits = paramListeners.split(",| ");
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("found portalListener config: " + Arrays.toString(splits)));
                    }
                    for (Object className : splits) {
                        if (((String)(className = ((String)className).trim())).length() <= 0) continue;
                        try {
                            Class<?> clazz = Class.forName((String)className);
                            WindowListener l = (WindowListener)BeanUtils.instantiateClass(clazz);
                            list.add(l);
                            if (!logger.isInfoEnabled()) continue;
                            logger.info((Object)("add portalListener: " + l));
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                        }
                    }
                }
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

