/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.lang.reflect.Method;
import net.paoding.rose.web.ControllerInterceptorAdapter;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.portal.Pipe;
import net.paoding.rose.web.portal.PortalUtils;
import net.paoding.rose.web.portal.Window;
import net.paoding.rose.web.portal.impl.PipeImpl;

public class PipeInterceptor
extends ControllerInterceptorAdapter {
    public PipeInterceptor() {
        this.setPriority(10000);
    }

    protected boolean isForAction(Method actionMethod, Class<?> controllerClazz) {
        for (Class<?> paramType : actionMethod.getParameterTypes()) {
            if (paramType != Pipe.class) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object after(Invocation inv, Object instruction) {
        Pipe pipe = PortalUtils.getPipe(inv);
        if (pipe != null && pipe.getInvocation() == inv) {
            boolean debugEnabled = this.logger.isDebugEnabled();
            if (debugEnabled) {
                this.logger.debug((Object)(pipe + " is going to wait pipe windows' ins."));
            }
            long begin = System.currentTimeMillis();
            long deadline = pipe.getTimeout() > 0L ? begin + pipe.getTimeout() : -1L;
            try {
                for (Window window : pipe.getWindows()) {
                    if (window.get("$$paoding-rose-portal.window.in") == Boolean.TRUE) continue;
                    Window window2 = window;
                    synchronized (window2) {
                        while (window.get("$$paoding-rose-portal.window.in") != Boolean.TRUE) {
                            long now = System.currentTimeMillis();
                            if (deadline <= 0L) {
                                if (debugEnabled) {
                                    this.logger.debug((Object)("waitting for window '" + window.getName() + "''s in; timetou=never"));
                                }
                                window.wait();
                                continue;
                            }
                            if (deadline > now) {
                                if (debugEnabled) {
                                    this.logger.debug((Object)("waitting for window '" + window.getName() + "''s in; timetou=" + (deadline - now)));
                                }
                                window.wait(deadline - now);
                                continue;
                            }
                            if (!this.logger.isInfoEnabled()) break;
                            this.logger.info((Object)("break waiting for this window's in '" + window.getName() + "@" + window.getContainer().getInvocation().getRequestPath() + "'"));
                            break;
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"window-in waiting is interruptted.", (Throwable)e);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(pipe + ".window-in is done; cost=" + (System.currentTimeMillis() - begin)));
            }
        }
        return instruction;
    }

    public void afterCompletion(Invocation inv, Throwable ex) throws Exception {
        if (ex != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"close the pipe and returen because of exception previous.");
            }
            return;
        }
        PipeImpl pipe = (PipeImpl)PortalUtils.getPipe(inv);
        if (pipe == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"there's no pipe windows.");
            }
            return;
        }
        if (inv != inv.getHeadInvocation()) {
            return;
        }
        if (!pipe.isStarted()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("writing " + pipe + "..."));
            }
            pipe.write(inv.getResponse().getWriter());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("writing " + pipe + "... done"));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(pipe + " has been started yet."));
        }
    }
}

