/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.portal.Pipe;
import net.paoding.rose.web.portal.Window;
import net.paoding.rose.web.portal.WindowListener;
import net.paoding.rose.web.portal.WindowListenerAdapter;
import net.paoding.rose.web.portal.impl.DefaultPipeRender;
import net.paoding.rose.web.portal.impl.GenericWindowContainer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PipeImpl
extends GenericWindowContainer
implements Pipe {
    public static final String WINDIW_JS = "$$paoding-rose-portal.pipe.js";
    public static final String WINDOW_CSS = "$$paoding-rose-portal.pipe.css";
    private static final Log logger = LogFactory.getLog(PipeImpl.class);
    private static final DefaultPipeRender defaultPipeRender = new DefaultPipeRender();
    private int state = 0;
    private CountDownLatch latch;
    private List<Window> blocking;
    private Writer out;

    public PipeImpl(Invocation inv, ExecutorService executorService, WindowListener portalListener) {
        super(inv, executorService, portalListener);
        this.setWindowRender(defaultPipeRender);
        this.addListener(new FireListener());
    }

    @Override
    public void addCssTo(String windowName, String css) {
        for (Window window : this.windows) {
            if (!window.getName().equals(windowName)) continue;
            this.addCssTo(window, css);
            return;
        }
    }

    protected void addCssTo(Window window, String css) {
        ArrayList<String> list = (ArrayList<String>)window.get(WINDOW_CSS);
        if (list == null) {
            list = new ArrayList<String>(4);
            window.set(WINDOW_CSS, list);
        }
        list.add(css);
    }

    @Override
    public void addJsTo(String windowName, String js) {
        for (Window window : this.windows) {
            if (!window.getName().equals(windowName)) continue;
            this.addJsTo(window, js);
            return;
        }
    }

    protected void addJsTo(Window window, String js) {
        ArrayList<String> list = (ArrayList<String>)window.get(WINDIW_JS);
        if (list == null) {
            list = new ArrayList<String>(4);
            window.set(WINDIW_JS, list);
        }
        list.add(js);
    }

    public synchronized boolean isStarted() {
        return this.out != null;
    }

    public void write(Writer out) throws IOException {
        if (this.isStarted()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + " has been started yet."));
            }
            return;
        }
        this.doStart(out);
        if (this.getTimeout() >= 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("waiting for pipe windows up to " + this.getTimeout() + "ms"));
            }
            long start = System.currentTimeMillis();
            try {
                this.await(this.getTimeout());
            }
            catch (InterruptedException e) {
                logger.error((Object)"pipe was interrupted", (Throwable)e);
            }
            long cost = System.currentTimeMillis() - start;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("it takes " + cost + "ms for pipe windows."));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"there's no time to wait pipe windows.");
        }
    }

    private synchronized void doStart(Writer writer) throws IOException {
        if (this.out != null) {
            throw new IllegalStateException("has been started.");
        }
        this.out = writer;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("start pipe " + this.getInvocation().getRequestPath().getUri()));
        }
        writer.flush();
        this.latch = new CountDownLatch(this.windows.size());
        this.state = 1;
        if (this.blocking != null) {
            for (Window window : this.blocking) {
                this.doFire(window);
            }
            this.blocking = null;
        }
    }

    private void await(long timeout) throws InterruptedException {
        if (timeout > 0L) {
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
        } else {
            this.latch.await();
        }
    }

    private synchronized void fire(Window window) throws IOException {
        if (!this.windows.contains(window)) {
            throw new IllegalArgumentException("not a register piped window '" + window.getName() + "'");
        }
        if (this.state < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("firing '" + window.getName() + "' but pipe is closed"));
            }
            return;
        }
        if (this.state == 0) {
            if (this.blocking == null) {
                this.blocking = new ArrayList<Window>(this.windows.size());
            } else if (this.blocking.contains(window)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("firing '" + window.getName() + "' : has been add to waiting list"));
                }
                return;
            }
            this.blocking.add(window);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("firing '" + window.getName() + "' : add to waiting list"));
            }
        } else {
            this.doFire(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doFire(Window window) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException("only avalabled when started.");
        }
        try {
            this.render(this.out, window);
            this.out.flush();
        }
        finally {
            this.latch.countDown();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("firing '" + window.getName() + "' : done  content=" + window.getContent()));
        }
    }

    @Override
    public String toString() {
        return "pipe ['" + this.getInvocation().getRequestPath().getUri() + "']";
    }

    private class FireListener
    extends WindowListenerAdapter {
        private FireListener() {
        }

        @Override
        public void onWindowDone(Window window) {
            try {
                PipeImpl.this.fire(window);
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }
}

