/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.portal.Window;
import net.paoding.rose.web.portal.WindowCallback;
import net.paoding.rose.web.portal.WindowContainer;
import net.paoding.rose.web.portal.WindowListener;
import net.paoding.rose.web.portal.WindowListeners;
import net.paoding.rose.web.portal.WindowRender;
import net.paoding.rose.web.portal.impl.NestedWindowRender;
import net.paoding.rose.web.portal.impl.WindowForView;
import net.paoding.rose.web.portal.impl.WindowFuture;
import net.paoding.rose.web.portal.impl.WindowImpl;
import net.paoding.rose.web.portal.impl.WindowRequest;
import net.paoding.rose.web.portal.impl.WindowResponse;
import net.paoding.rose.web.portal.impl.WindowTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GenericWindowContainer
implements WindowRender,
WindowContainer,
WindowListener {
    private static final Log logger = LogFactory.getLog(GenericWindowContainer.class);
    protected static final NestedWindowRender singletonRender = new NestedWindowRender();
    protected NestedWindowRender render = singletonRender;
    protected ExecutorService executorService;
    protected WindowListeners windowListeners;
    protected Invocation invocation;
    protected List<Window> windows = new LinkedList<Window>();
    protected long timeout;

    public GenericWindowContainer(Invocation inv, ExecutorService executorService, WindowListener portalListener) {
        this.invocation = inv;
        this.executorService = executorService;
        this.addListener(portalListener);
    }

    @Override
    public void setTimeout(long timeoutInMills) {
        this.timeout = timeoutInMills;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    @Deprecated
    public void addModel(String name, Object value) {
        this.getInvocation().addModel(name, value);
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.invocation.getRequest();
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.invocation.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(WindowListener l) {
        if (l == null) {
            return;
        }
        GenericWindowContainer genericWindowContainer = this;
        synchronized (genericWindowContainer) {
            if (this.windowListeners == null) {
                this.windowListeners = new WindowListeners();
            }
            this.windowListeners.addListener(l);
        }
    }

    @Override
    public Window addWindow(String name, String windowPath) {
        return this.addWindow(name, windowPath, (WindowCallback)null);
    }

    @Override
    public Window addWindow(String name, String windowPath, final Map<String, Object> attributes) {
        WindowCallback callback = null;
        if (attributes != null && attributes.size() > 0) {
            callback = new WindowCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void beforeSubmit(Window window) {
                    Map map = attributes;
                    synchronized (map) {
                        for (Map.Entry entry : attributes.entrySet()) {
                            window.set((String)entry.getKey(), entry.getValue());
                        }
                    }
                }
            };
        }
        return this.addWindow(name, windowPath, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Window addWindow(String name, String windowPath, WindowCallback callback) {
        WindowImpl window = new WindowImpl(this, name, windowPath);
        WindowRequest request = new WindowRequest(window, this.getRequest());
        WindowResponse response = new WindowResponse(window);
        request.setAttribute("$$paoding-rose-portal.window.name", name);
        request.setAttribute("$$paoding-rose-portal.window.path", windowPath);
        request.removeAttribute("$$paoding-rose-portal.window.in");
        WindowTask task = new WindowTask(window, request, response);
        WindowForView windowInView = new WindowForView(window);
        List<Window> list = this.windows;
        synchronized (list) {
            this.windows.add(windowInView);
        }
        this.invocation.addModel(name, (Object)windowInView);
        if (callback != null) {
            callback.beforeSubmit(window);
        }
        this.onWindowAdded(window);
        WindowFuture<?> future = this.submitWindow(this.executorService, task);
        window.setFuture(future);
        return window;
    }

    @Override
    public List<Window> getWindows() {
        return this.windows;
    }

    @Override
    public WindowRender getWindowRender() {
        return this.render.getInnerRender();
    }

    @Override
    public void setWindowRender(WindowRender render) {
        if (render == null) {
            this.render = singletonRender;
        } else if (this.render == singletonRender) {
            this.render = new NestedWindowRender(render);
        } else {
            this.render.setInnerRender(render);
        }
    }

    protected WindowFuture<?> submitWindow(ExecutorService executor, WindowTask task) {
        Future<?> future = executor.submit(task);
        return new WindowFuture(future, task.getWindow());
    }

    @Override
    public void render(Writer out, Window window) throws IOException {
        this.render.render(out, window);
    }

    public String toString() {
        return "aggregate ['" + this.invocation.getRequestPath().getUri() + "']";
    }

    @Override
    public void onWindowAdded(Window window) {
        if (this.windowListeners != null) {
            try {
                this.windowListeners.onWindowAdded(window);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public void onWindowStarted(Window window) {
        if (this.windowListeners != null) {
            try {
                this.windowListeners.onWindowStarted(window);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public void onWindowCanceled(Window window) {
        if (this.windowListeners != null) {
            try {
                this.windowListeners.onWindowCanceled(window);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public void onWindowDone(Window window) {
        if (this.windowListeners != null) {
            try {
                this.windowListeners.onWindowDone(window);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public void onWindowError(Window window) {
        if (this.windowListeners != null) {
            try {
                this.windowListeners.onWindowError(window);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    @Override
    public void onWindowTimeout(Window window) {
        if (this.windowListeners != null) {
            try {
                this.windowListeners.onWindowTimeout(window);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }
}

