/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.portal;

import java.util.ArrayList;
import java.util.List;
import net.paoding.rose.web.portal.Window;
import net.paoding.rose.web.portal.WindowListener;

public class WindowListeners
implements WindowListener {
    private List<WindowListener> listeners = new ArrayList<WindowListener>();

    public void setListeners(List<WindowListener> listeners) {
        ArrayList<WindowListener> copied = new ArrayList<WindowListener>(listeners);
        for (WindowListener portalListener : copied) {
            if (portalListener != null) continue;
            throw new NullPointerException("PortalListener");
        }
        this.listeners = copied;
    }

    public void addListener(WindowListener l) {
        if (l == null) {
            throw new NullPointerException("PortalListener");
        }
        this.listeners.add(l);
    }

    @Override
    public void onWindowAdded(Window window) {
        for (WindowListener l : this.listeners) {
            l.onWindowAdded(window);
        }
    }

    @Override
    public void onWindowCanceled(Window window) {
        for (WindowListener l : this.listeners) {
            l.onWindowCanceled(window);
        }
    }

    @Override
    public void onWindowDone(Window window) {
        for (WindowListener l : this.listeners) {
            l.onWindowDone(window);
        }
    }

    @Override
    public void onWindowError(Window window) {
        for (WindowListener l : this.listeners) {
            l.onWindowError(window);
        }
    }

    @Override
    public void onWindowStarted(Window window) {
        for (WindowListener l : this.listeners) {
            l.onWindowStarted(window);
        }
    }

    @Override
    public void onWindowTimeout(Window window) {
        for (WindowListener l : this.listeners) {
            l.onWindowTimeout(window);
        }
    }
}

