/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load.vfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.paoding.rose.load.vfs.FileContent;
import net.paoding.rose.load.vfs.FileName;
import net.paoding.rose.load.vfs.FileNameImpl;
import net.paoding.rose.load.vfs.FileObject;
import net.paoding.rose.load.vfs.FileSystemManager;
import net.paoding.rose.load.vfs.FileType;
import org.springframework.util.ResourceUtils;

public class SimpleFileObject
implements FileObject {
    private final URL url;
    private final String urlString;
    private final File file;
    private final FileName fileName;
    private final FileSystemManager fs;

    SimpleFileObject(FileSystemManager fs, URL url) throws FileNotFoundException, MalformedURLException {
        this.fs = fs;
        File file = ResourceUtils.getFile((URL)url);
        String urlString = url.toString();
        this.url = url;
        this.file = file;
        this.urlString = urlString;
        this.fileName = new FileNameImpl(this, file.getName());
    }

    @Override
    public FileObject getChild(String child) throws IOException {
        return this.fs.resolveFile(this.urlString + child);
    }

    @Override
    public FileObject[] getChildren() throws MalformedURLException, IOException {
        File[] files = this.file.listFiles();
        FileObject[] children = new FileObject[files.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = files[i].isDirectory() ? this.fs.resolveFile(this.urlString + files[i].getName() + "/") : this.fs.resolveFile(this.urlString + files[i].getName());
        }
        return children;
    }

    @Override
    public FileContent getContent() throws IOException {
        if (!this.file.canRead()) {
            throw new IOException("can not read");
        }
        return new FileContent(){

            @Override
            public InputStream getInputStream() throws IOException {
                return new FileInputStream(SimpleFileObject.this.file);
            }
        };
    }

    @Override
    public FileName getName() {
        return this.fileName;
    }

    @Override
    public FileObject getParent() throws MalformedURLException, IOException {
        File parent = this.file.getParentFile();
        if (parent == null) {
            return null;
        }
        return this.fs.resolveFile(parent.toURI().toURL());
    }

    @Override
    public FileType getType() {
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.UNKNOWN;
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return this.url;
    }

    @Override
    public boolean exists() throws IOException {
        return this.file.exists();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleFileObject)) {
            return false;
        }
        SimpleFileObject t = (SimpleFileObject)obj;
        return this.file.equals(t.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode() * 13;
    }

    public String toString() {
        return this.urlString;
    }
}

