/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load.vfs;

import java.io.IOException;
import net.paoding.rose.load.vfs.FileName;
import net.paoding.rose.load.vfs.FileObject;

public class FileNameImpl
implements FileName {
    private final FileObject fileObject;
    private final String baseName;

    public FileNameImpl(FileObject fileObject, String baseName) {
        this.fileObject = fileObject;
        this.baseName = baseName;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public String getRelativeName(FileName subFileName) throws IOException {
        String basePath = this.fileObject.getURL().getPath();
        String subPath = subFileName.getFileObject().getURL().getPath();
        if (!subPath.startsWith(basePath)) {
            throw new IllegalArgumentException("basePath='" + basePath + "'; subPath='" + subPath + "'");
        }
        return subPath.substring(basePath.length());
    }
}

