/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load.context;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletContext;
import net.paoding.rose.load.LoadScope;
import net.paoding.rose.load.context.core.RoseResources;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class RoseWebAppContext
extends XmlWebApplicationContext {
    public static final String DEFAULT_CONFIG_LOCATION = "/WEB-INF/applicationContext*.xml";
    private LoadScope scope;

    public RoseWebAppContext(ServletContext servletContext, boolean refresh) {
        this(servletContext, "", refresh);
    }

    public RoseWebAppContext(ServletContext servletContext, String scope, boolean refresh) {
        this(servletContext, new LoadScope(scope, "controllers"), refresh);
    }

    public RoseWebAppContext(ServletContext servletContext, LoadScope scope, boolean refresh) {
        this.scope = scope;
        this.setServletContext(servletContext);
        if (refresh) {
            this.refresh();
        }
    }

    public <T> T getBean(Class<T> beanType) throws BeansException {
        return beanType.cast(BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this, beanType));
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        String[] configLocations;
        Resource[] configResources = this.getConfigResourcesThrows();
        if (configResources != null) {
            reader.loadBeanDefinitions(configResources);
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            for (int i = 0; i < configLocations.length; ++i) {
                reader.loadBeanDefinitions(configLocations[i]);
            }
        }
    }

    protected Resource[] getConfigResourcesThrows() throws IOException {
        return RoseResources.findContextResources(this.scope).toArray(new Resource[0]);
    }

    protected String[] getDefaultConfigLocations() {
        return new String[]{DEFAULT_CONFIG_LOCATION};
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        try {
            this.prepareBeanFactoryByRose(beanFactory);
        }
        catch (IOException e) {
            throw new ApplicationContextException("", (Throwable)e);
        }
        super.prepareBeanFactory(beanFactory);
    }

    protected void prepareBeanFactoryByRose(ConfigurableListableBeanFactory beanFactory) throws IOException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)registry);
        String[] messageBaseNames = this.getMessageBaseNames();
        if (messageBaseNames != null && messageBaseNames.length > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"[roseWebApp/messages] starting registerMessageSourceIfNecessary");
            }
            RoseWebAppContext.registerMessageSourceIfNecessary(registry, messageBaseNames);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"[roseWebApp/messages] finished registerMessageSourceIfNecessary");
            }
        }
    }

    protected String[] getMessageBaseNames() throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[roseWebApp/messages] start  ...");
        }
        String[] messageBasenames = RoseResources.findMessageBasenames(this.scope);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"[roseWebApp/messages] exits ");
            this.logger.info((Object)"[roseWebApp/messages] add default messages base name: '/WEB-INF/messages'");
        }
        messageBasenames = Arrays.copyOf(messageBasenames, messageBasenames.length + 1);
        messageBasenames[messageBasenames.length - 1] = "/WEB-INF/messages";
        return messageBasenames;
    }

    public static void registerMessageSourceIfNecessary(BeanDefinitionRegistry registry, String[] messageBaseNames) {
        if (!registry.containsBeanDefinition("messageSource")) {
            GenericBeanDefinition messageSource = new GenericBeanDefinition();
            messageSource.setBeanClass(ReloadableResourceBundleMessageSource.class);
            MutablePropertyValues propertyValues = new MutablePropertyValues();
            propertyValues.addPropertyValue("useCodeAsDefaultMessage", (Object)true);
            propertyValues.addPropertyValue("defaultEncoding", (Object)"UTF-8");
            propertyValues.addPropertyValue("cacheSeconds", (Object)60);
            propertyValues.addPropertyValue("basenames", (Object)messageBaseNames);
            messageSource.setPropertyValues(propertyValues);
            registry.registerBeanDefinition("messageSource", (BeanDefinition)messageSource);
        }
    }
}

