/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class ResourceRef
implements Comparable<ResourceRef> {
    private static final Log logger = LogFactory.getLog(ResourceRef.class);
    private Properties properties = new Properties();
    private Resource resource;
    private String[] modifiers;

    public static ResourceRef toResourceRef(Resource folder) throws IOException {
        ResourceRef rr = new ResourceRef(folder, null, null);
        Object[] modifiers = null;
        Resource rosePropertiesResource = rr.getInnerResource("META-INF/rose.properties");
        if (rosePropertiesResource.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("found rose.properties: " + rosePropertiesResource.getURI()));
            }
            InputStream in = rosePropertiesResource.getInputStream();
            rr.properties.load(in);
            in.close();
            String attrValue = rr.properties.getProperty("rose");
            if (attrValue == null) {
                attrValue = rr.properties.getProperty("Rose");
            }
            if (attrValue != null) {
                modifiers = StringUtils.split((String)attrValue, (String)", ;\n\r\t");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("modifiers[by properties][" + rr.getResource().getURI() + "]=" + Arrays.toString(modifiers)));
                }
            }
        }
        if (modifiers == null) {
            if (!"jar".equals(rr.getProtocol())) {
                modifiers = new String[]{"**"};
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("modifiers[by default][" + rr.getResource().getURI() + "]=" + Arrays.toString(modifiers)));
                }
            } else {
                JarFile jarFile = new JarFile(rr.getResource().getFile());
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    String attrValue = attributes.getValue("rose");
                    if (attrValue == null) {
                        attrValue = attributes.getValue("Rose");
                    }
                    if (attrValue != null) {
                        modifiers = StringUtils.split((String)attrValue, (String)", ;\n\r\t");
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("modifiers[by manifest.mf][" + rr.getResource().getURI() + "]=" + Arrays.toString(modifiers)));
                        }
                    }
                }
            }
        }
        rr.setModifiers((String[])modifiers);
        return rr;
    }

    public ResourceRef(Resource resource, String[] modifiers, Properties p) {
        this.setResource(resource);
        if (modifiers != null) {
            this.setModifiers(modifiers);
        }
        if (p != null) {
            this.properties.putAll((Map<?, ?>)p);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String[] getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(String[] modifiers) {
        this.modifiers = modifiers;
        if (modifiers == null) {
            this.properties.remove("rose");
        } else {
            StringBuilder sb = new StringBuilder();
            String separator = ", ";
            for (String m : modifiers) {
                sb.append(m).append(", ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - ", ".length());
            }
            this.properties.put("rose", sb.toString());
        }
    }

    public boolean hasModifier(String modifier) {
        if (modifier.startsWith("<") && modifier.endsWith(">")) {
            return ArrayUtils.contains((Object[])this.modifiers, (Object)modifier.substring(1, modifier.length() - 1));
        }
        return ArrayUtils.contains((Object[])this.modifiers, (Object)"**") || ArrayUtils.contains((Object[])this.modifiers, (Object)"*") || ArrayUtils.contains((Object[])this.modifiers, (Object)modifier);
    }

    public Resource getInnerResource(String subPath) throws IOException {
        Assert.isTrue((!subPath.startsWith("/") ? 1 : 0) != 0);
        String rootPath = this.resource.getURI().getPath();
        if (this.getProtocol().equals("jar")) {
            return new UrlResource("jar:file:" + rootPath + "!/" + subPath);
        }
        return new FileSystemResource(rootPath + subPath);
    }

    public Resource[] getInnerResources(ResourcePatternResolver resourcePatternResolver, String subPath) throws IOException {
        subPath = this.getInnerResourcePattern(subPath);
        return resourcePatternResolver.getResources(subPath);
    }

    public String getInnerResourcePattern(String subPath) throws IOException {
        Assert.isTrue((!subPath.startsWith("/") ? 1 : 0) != 0, (String)subPath);
        String rootPath = this.resource.getURI().getPath();
        subPath = this.getProtocol().equals("jar") ? "jar:file:" + rootPath + "!/" + subPath : "file:" + rootPath + subPath;
        return subPath;
    }

    public String getProtocol() {
        if (this.resource.getFilename().toLowerCase().endsWith(".jar") || this.resource.getFilename().toLowerCase().endsWith(".zip") || this.resource.getFilename().toLowerCase().endsWith(".tar") || this.resource.getFilename().toLowerCase().endsWith(".gz")) {
            return "jar";
        }
        return "file";
    }

    @Override
    public int compareTo(ResourceRef o) {
        try {
            return this.resource.getURI().compareTo(o.resource.getURI());
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public int hashCode() {
        return 13 * this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.resource == null) {
            return false;
        }
        if (obj instanceof Resource) {
            return this.resource.equals(obj);
        }
        if (obj instanceof ResourceRef) {
            return this.resource.equals(((ResourceRef)obj).resource);
        }
        return false;
    }

    public String toString() {
        Object[] modifiers = this.modifiers;
        if (modifiers == null) {
            modifiers = new String[]{};
        }
        try {
            return this.resource.getURL().getFile() + Arrays.toString(modifiers);
        }
        catch (IOException e) {
            return this.resource + Arrays.toString(modifiers);
        }
    }
}

