/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LoadScope {
    private Map<String, String[]> load = new HashMap<String, String[]>();

    public LoadScope(String loadScopeString, String defType) {
        this.init(loadScopeString, defType);
    }

    public String[] getScope(String componentType) {
        String[] scope = this.load.get(componentType);
        if (scope == null) {
            scope = this.load.get("*");
        }
        return scope;
    }

    private void init(String loadScope, String defType) {
        String[] componetConfs;
        if (StringUtils.isBlank((String)loadScope) || "*".equals(loadScope)) {
            return;
        }
        loadScope = loadScope.trim();
        for (String componetConf : componetConfs = StringUtils.split((String)loadScope, (String)";")) {
            if (StringUtils.isBlank((String)loadScope)) continue;
            componetConf = componetConf.trim();
            String componetType = defType;
            String componetConfValue = componetConf;
            int componetTypeIndex = componetConf.indexOf(61);
            if (componetTypeIndex != -1) {
                componetType = componetConf.substring(0, componetTypeIndex).trim();
                componetConfValue = componetConf.substring(componetTypeIndex + 1).trim();
            }
            if (componetType.startsWith("!")) {
                componetType = componetType.substring(1);
            } else {
                componetConfValue = componetConfValue + ", net.paoding.rose";
            }
            String[] packages = StringUtils.split((String)componetConfValue, (String)", \t\n\r\u0000");
            this.load.put(componetType, packages);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> componetConf : this.load.entrySet()) {
            String componetType = componetConf.getKey();
            String[] componetConfValue = componetConf.getValue();
            sb.append(componetType).append("=");
            for (String value : componetConfValue) {
                sb.append(value).append(";");
            }
            if (componetConfValue.length <= 0) continue;
            sb.setLength(sb.length() - 1);
        }
        return super.toString();
    }
}

