/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load.vfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.paoding.rose.load.vfs.FileContent;
import net.paoding.rose.load.vfs.FileName;
import net.paoding.rose.load.vfs.FileNameImpl;
import net.paoding.rose.load.vfs.FileObject;
import net.paoding.rose.load.vfs.FileSystemManager;
import net.paoding.rose.load.vfs.FileType;

public class JarFileObject
implements FileObject {
    private final FileSystemManager fs;
    private final URL url;
    private final String urlString;
    private final FileName fileName;
    private final JarFileObject root;
    private final JarFile jarFile;
    private final JarEntry entry;

    JarFileObject(FileSystemManager fs, URL url) throws FileNotFoundException, IOException {
        this.fs = fs;
        String urlString = url.toString();
        String entryName = urlString.substring(urlString.indexOf("!/") + "!/".length());
        if (entryName.length() == 0) {
            this.root = this;
            int beginIndex = urlString.indexOf("file:") + "file:".length();
            int endIndex = urlString.indexOf("!/");
            this.jarFile = new JarFile(urlString.substring(beginIndex, endIndex));
        } else {
            this.root = (JarFileObject)fs.resolveFile(urlString.substring(0, urlString.indexOf("!/") + "!/".length()));
            this.jarFile = this.root.jarFile;
        }
        this.entry = this.jarFile.getJarEntry(entryName);
        this.url = url;
        this.urlString = urlString;
        int indexSep = entryName.lastIndexOf(47);
        if (indexSep == -1) {
            this.fileName = new FileNameImpl(this, entryName);
        } else if (entryName.endsWith("/")) {
            int index = entryName.lastIndexOf(47, entryName.length() - 2);
            this.fileName = new FileNameImpl(this, entryName.substring(index + 1, indexSep));
        } else {
            this.fileName = new FileNameImpl(this, entryName.substring(indexSep + 1));
        }
    }

    @Override
    public FileObject getChild(String name) throws IOException {
        return this.fs.resolveFile(this.urlString + name);
    }

    @Override
    public FileObject[] getChildren() throws IOException {
        String entryName;
        LinkedList<FileObject> children = new LinkedList<FileObject>();
        Enumeration<JarEntry> e = this.jarFile.entries();
        String string = entryName = this.root == this ? "" : this.entry.getName();
        while (e.hasMoreElements()) {
            int index;
            JarEntry entry = e.nextElement();
            if (entry.getName().length() <= entryName.length() || !entry.getName().startsWith(entryName) || (index = entry.getName().indexOf(47, entryName.length() + 1)) != -1 && index != entry.getName().length() - 1) continue;
            children.add(this.fs.resolveFile(this.root.urlString + entry.getName()));
        }
        return children.toArray(new FileObject[0]);
    }

    @Override
    public FileContent getContent() throws IOException {
        if (this.getType() != FileType.FILE) {
            throw new IOException("can not read");
        }
        return new FileContent(){

            @Override
            public InputStream getInputStream() throws IOException {
                return JarFileObject.this.getURL().openStream();
            }
        };
    }

    @Override
    public FileName getName() throws IOException {
        return this.fileName;
    }

    @Override
    public FileObject getParent() throws IOException {
        if (this.entry == null) {
            return null;
        }
        if (this.entry.getName().length() == 0) {
            return null;
        }
        int lastSep = this.entry.getName().lastIndexOf(47);
        if (lastSep == -1) {
            return this.root;
        }
        String entryName = this.entry.getName();
        String parentEntryName = this.entry.isDirectory() ? entryName.substring(0, 1 + entryName.lastIndexOf(47, entryName.length() - 2)) : entryName.substring(0, 1 + lastSep);
        return this.fs.resolveFile(this.root.urlString + parentEntryName);
    }

    @Override
    public FileType getType() throws IOException {
        return this.entry == null || this.entry.isDirectory() ? FileType.FOLDER : FileType.FILE;
    }

    @Override
    public URL getURL() throws IOException {
        return this.url;
    }

    @Override
    public boolean exists() throws IOException {
        return this.root == this || this.entry != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JarFileObject)) {
            return false;
        }
        JarFileObject t = (JarFileObject)obj;
        return this.urlString.equals(t.urlString);
    }

    @Override
    public int hashCode() {
        return this.urlString.hashCode() * 13;
    }

    public String toString() {
        return this.urlString;
    }
}

