/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load.vfs;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import net.paoding.rose.load.vfs.FileObject;
import net.paoding.rose.load.vfs.JarFileObject;
import net.paoding.rose.load.vfs.SimpleFileObject;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ResourceUtils;

public class FileSystemManager {
    protected Log logger = LogFactory.getLog(FileSystemManager.class);
    private boolean traceEnabled = this.logger.isTraceEnabled();
    private Map<String, FileObject> cached = new LRUMap(10000);

    public FileObject resolveFile(String urlString) throws IOException {
        FileObject object;
        if (this.traceEnabled) {
            this.logger.trace((Object)("[fs] resolveFile ... by urlString '" + urlString + "'"));
        }
        if ((object = this.cached.get(urlString)) == null && !urlString.endsWith("/")) {
            object = this.cached.get(urlString + "/");
        }
        if (object != null) {
            if (this.traceEnabled) {
                this.logger.trace((Object)("[fs][s] found cached file for urlString '" + urlString + "'"));
            }
            return object;
        }
        return this.resolveFile(new URL(urlString));
    }

    public synchronized FileObject resolveFile(URL url) throws IOException {
        try {
            String urlString;
            FileObject object;
            if (this.traceEnabled) {
                this.logger.trace((Object)("[fs] resolveFile ... by url '" + url + "'"));
            }
            if ((object = this.cached.get(urlString = url.toString())) != null) {
                if (this.traceEnabled) {
                    this.logger.trace((Object)("[fs] found cached file for url '" + urlString + "'"));
                }
                return object;
            }
            if (ResourceUtils.isJarURL((URL)url)) {
                if (!urlString.endsWith("/")) {
                    object = this.resolveFile(urlString + "/");
                }
                if (object == null || !object.exists()) {
                    object = new JarFileObject(this, url);
                    if (this.traceEnabled) {
                        this.logger.trace((Object)("[fs] create jarFileObject for '" + urlString + "'"));
                    }
                }
            } else {
                File file = ResourceUtils.getFile((URL)url);
                if (file.isDirectory()) {
                    if (!urlString.endsWith("/")) {
                        urlString = urlString + "/";
                        url = new URL(urlString);
                    }
                } else if (file.isFile() && urlString.endsWith("/")) {
                    urlString = StringUtils.removeEnd((String)urlString, (String)"/");
                    url = new URL(urlString);
                }
                object = new SimpleFileObject(this, url);
                if (this.traceEnabled) {
                    this.logger.trace((Object)("[fs] create simpleFileObject for '" + urlString + "'"));
                }
            }
            if (object.exists()) {
                this.cached.put(urlString, object);
            }
            return object;
        }
        catch (IOException e) {
            this.logger.error((Object)(e.getMessage() + ":" + url), (Throwable)e);
            throw e;
        }
    }

    public synchronized void clearCache() {
        this.cached.clear();
    }
}

