/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load.context.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.paoding.rose.load.LoadScope;
import net.paoding.rose.load.ResourceRef;
import net.paoding.rose.load.RoseScanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class RoseResources {
    protected static Log logger = LogFactory.getLog(RoseResources.class);

    public static List<Resource> findContextResources(LoadScope load) throws IOException {
        String[] scopeValues = load.getScope("applicationContext");
        return RoseResources.findContextResources(scopeValues);
    }

    public static List<Resource> findContextResources(String[] scope) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"[applicationContext] start to found applicationContext files ...");
        }
        if (logger.isDebugEnabled()) {
            if (scope == null) {
                logger.debug((Object)"[applicationContext] use default scope [all class folders and rosed jar files]");
            } else {
                logger.debug((Object)("[applicationContext] use scope: " + Arrays.toString(scope)));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[applicationContext] call 'findFiles'");
        }
        List<ResourceRef> resources = RoseScanner.getInstance().getJarOrClassesFolderResources(scope);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[applicationContext] exits from 'findFiles'");
            logger.debug((Object)("[applicationContext] it has " + resources.size() + " classes folders or jar files " + "in the applicationContext scope: " + resources));
            logger.debug((Object)("[applicationContext] iterates the 'findFiles' classes folders or jar files; size=" + resources.size()));
        }
        LinkedList<Resource> ctxResources = new LinkedList<Resource>();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        int index = 0;
        for (ResourceRef ref : resources) {
            ++index;
            if (ref.hasModifier("applicationContext")) {
                Resource[] founds = ref.getInnerResources((ResourcePatternResolver)resourcePatternResolver, "applicationContext*.xml");
                List<Resource> asList = Arrays.asList(founds);
                ctxResources.addAll(asList);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("[applicationContext] found applicationContext resources (" + index + "/" + resources.size() + ": " + asList));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("[applicationContext] ignored bacause not marked as 'rose:applicationContext' or 'rose:*'  (" + index + "/" + resources.size() + ": " + ref));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[applicationContext] FOUND " + ctxResources.size() + " applcationContext files: " + ctxResources));
        }
        return ctxResources;
    }

    public static String[] findMessageBasenames(LoadScope load) throws IOException {
        String[] scopeValues = load.getScope("messages");
        return RoseResources.findMessageBasenames(scopeValues);
    }

    public static String[] findMessageBasenames(String[] scope) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"[messages] start to found rose.root 'messages' files ...");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[messages] call 'scoped'");
        }
        List<ResourceRef> resources = RoseScanner.getInstance().getJarOrClassesFolderResources(scope);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[messages] exits from 'scoped'");
            logger.debug((Object)("[messages] it has " + resources.size() + " classes folders or jar files " + "in the messages scope: " + resources));
            logger.debug((Object)("[messages] iterates the 'scoped' classes folders or jar files; size=" + resources.size()));
        }
        LinkedList<String> messagesResources = new LinkedList<String>();
        int index = 0;
        for (ResourceRef ref : resources) {
            ++index;
            if (ref.hasModifier("messages")) {
                messagesResources.add(ref.getInnerResourcePattern("messages"));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("[messages] add messages base name (" + index + "/" + resources.size() + ": " + ref));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("[messages] ignored bacause not marked as 'rose:messages' or 'rose:*'  (" + index + "/" + resources.size() + ": " + ref));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[messages] found " + messagesResources.size() + " messages base names: " + messagesResources));
        }
        return messagesResources.toArray(new String[0]);
    }
}

