/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load.context;

import java.io.IOException;
import net.paoding.rose.load.LoadScope;
import net.paoding.rose.load.context.core.RoseResources;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class RoseAppContext
extends AbstractXmlApplicationContext {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String[] scopeValues;

    public RoseAppContext() {
        this("", true);
    }

    public RoseAppContext(String scope, boolean refresh) {
        this(new LoadScope(scope, "applicationContext"), refresh);
    }

    public RoseAppContext(LoadScope scope, boolean refresh) {
        this.scopeValues = scope.getScope("applicationContext");
        this.logger.info((Object)("create a RoseAppContext, with scope='" + scope + "'"));
        if (refresh) {
            this.refresh();
        }
    }

    public <T> T getBean(Class<T> beanType) throws BeansException {
        return beanType.cast(BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this, beanType));
    }

    protected final Resource[] getConfigResources() {
        try {
            return this.getConfigResourcesThrowsIOException();
        }
        catch (IOException e) {
            throw new ApplicationContextException("getConfigResources", (Throwable)e);
        }
    }

    protected Resource[] getConfigResourcesThrowsIOException() throws IOException {
        return RoseResources.findContextResources(this.scopeValues).toArray(new Resource[0]);
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.prepareBeanFactoryByRose(beanFactory);
        super.prepareBeanFactory(beanFactory);
    }

    protected void prepareBeanFactoryByRose(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)registry);
    }

    public RoseAppContext getApplicationContext() {
        return this;
    }
}

