/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.load;

import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import net.paoding.rose.load.ResourceRef;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public class RoseScanner {
    private static SoftReference<RoseScanner> softReference;
    protected Log logger = LogFactory.getLog(this.getClass());
    protected Date createTime = new Date();
    protected ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private List<ResourceRef> classesFolderResources;
    private List<ResourceRef> jarResources;

    public static synchronized RoseScanner getInstance() {
        if (softReference == null || softReference.get() == null) {
            RoseScanner roseScanner = new RoseScanner();
            softReference = new SoftReference<RoseScanner>(roseScanner);
        }
        return softReference.get();
    }

    private RoseScanner() {
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public List<ResourceRef> getJarOrClassesFolderResources() throws IOException {
        return this.getJarOrClassesFolderResources(null);
    }

    public List<ResourceRef> getJarOrClassesFolderResources(String[] scope) throws IOException {
        LinkedList<ResourceRef> resources;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("[findFiles] start to found classes folders or rosed jar files by scope:" + Arrays.toString(scope)));
        }
        if (scope == null) {
            resources = new LinkedList<ResourceRef>();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"[findFiles] call 'classesFolder'");
            }
            resources.addAll(this.getClassesFolderResources());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"[findFiles] exits from 'classesFolder'");
                this.logger.debug((Object)"[findFiles] call 'jarFile'");
            }
            resources.addAll(this.getJarResources());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"[findFiles] exits from 'jarFile'");
            }
        } else {
            if (scope.length == 0) {
                return new ArrayList<ResourceRef>();
            }
            resources = new LinkedList();
            for (String scopeEntry : scope) {
                Resource[] packageResources;
                String packagePath = scopeEntry.replace('.', '/');
                for (Resource pkgResource : packageResources = this.resourcePatternResolver.getResources("classpath*:" + packagePath)) {
                    String path;
                    FileSystemResource folder;
                    ResourceRef ref;
                    String uri = pkgResource.getURI().toString();
                    uri = StringUtils.removeEnd((String)uri, (String)"/");
                    int beginIndex = (uri = StringUtils.removeEnd((String)uri, (String)(packagePath = StringUtils.removeEnd((String)packagePath, (String)"/")))).lastIndexOf("file:");
                    beginIndex = beginIndex == -1 ? 0 : (beginIndex += "file:".length());
                    int endIndex = uri.lastIndexOf(33);
                    if (endIndex == -1) {
                        endIndex = uri.length();
                    }
                    if (resources.contains(ref = ResourceRef.toResourceRef((Resource)(folder = new FileSystemResource(path = uri.substring(beginIndex, endIndex)))))) continue;
                    resources.add(ref);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("[findFiles] found classes folders or rosed jar files by scope:" + ref));
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("[findFiles] found " + resources.size() + " classes folders " + "or rosed jar files : " + resources));
        }
        return resources;
    }

    public List<ResourceRef> getClassesFolderResources() throws IOException {
        if (this.classesFolderResources == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"[classesFolder] start to found available classes folders ...");
            }
            ArrayList<ResourceRef> classesFolderResources = new ArrayList<ResourceRef>();
            Enumeration<URL> founds = this.resourcePatternResolver.getClassLoader().getResources("");
            while (founds.hasMoreElements()) {
                File file;
                URL urlObject = founds.nextElement();
                if (!"file".equals(urlObject.getProtocol())) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("[classesFolder] Ignored classes folder because not a file protocol url: " + urlObject));
                    continue;
                }
                String path = urlObject.getPath();
                Assert.isTrue((boolean)path.endsWith("/"));
                try {
                    file = new File(urlObject.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                if (file.isFile()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("[classesFolder] Ignored because not a directory: " + urlObject));
                    continue;
                }
                FileSystemResource resource = new FileSystemResource(file);
                ResourceRef resourceRef = ResourceRef.toResourceRef((Resource)resource);
                if (classesFolderResources.contains(resourceRef)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("[classesFolder] remove replicated classes folder: " + resourceRef));
                    continue;
                }
                classesFolderResources.add(resourceRef);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("[classesFolder] add classes folder: " + resourceRef));
            }
            Collections.sort(classesFolderResources);
            LinkedList<ResourceRef> toRemove = new LinkedList<ResourceRef>();
            for (int i = 0; i < classesFolderResources.size(); ++i) {
                ResourceRef ref = (ResourceRef)classesFolderResources.get(i);
                String refURI = ref.getResource().getURI().toString();
                for (int j = i + 1; j < classesFolderResources.size(); ++j) {
                    ResourceRef refj = (ResourceRef)classesFolderResources.get(j);
                    String refjURI = refj.getResource().getURI().toString();
                    if (refURI.startsWith(refjURI)) {
                        toRemove.add(refj);
                        if (!this.logger.isInfoEnabled()) continue;
                        this.logger.info((Object)("[classesFolder] remove wrapper classes folder: " + refj));
                        continue;
                    }
                    if (!refjURI.startsWith(refURI) || refURI.length() == refjURI.length()) continue;
                    toRemove.add(ref);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("[classesFolder] remove wrapper classes folder: " + ref));
                }
            }
            classesFolderResources.removeAll(toRemove);
            this.classesFolderResources = new ArrayList<ResourceRef>(classesFolderResources);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("[classesFolder] found " + classesFolderResources.size() + " classes folders: " + classesFolderResources));
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("[classesFolder] found cached " + this.classesFolderResources.size() + " classes folders: " + this.classesFolderResources));
        }
        return Collections.unmodifiableList(this.classesFolderResources);
    }

    public List<ResourceRef> getJarResources() throws IOException {
        if (this.jarResources == null) {
            Resource[] metaInfResources;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"[jarFile] start to found available jar files for rose to scanning...");
            }
            LinkedList<ResourceRef> jarResources = new LinkedList<ResourceRef>();
            for (Resource metaInfResource : metaInfResources = this.resourcePatternResolver.getResources("classpath*:/META-INF/")) {
                URL urlObject = metaInfResource.getURL();
                if (ResourceUtils.isJarURL((URL)urlObject)) {
                    try {
                        String path = URLDecoder.decode(urlObject.getPath(), "UTF-8");
                        path = path.startsWith("file:") ? path.substring("file:".length(), path.lastIndexOf(33)) : path.substring(0, path.lastIndexOf(33));
                        FileSystemResource resource = new FileSystemResource(path);
                        if (jarResources.contains(resource)) {
                            if (!this.logger.isDebugEnabled()) continue;
                            this.logger.debug((Object)("[jarFile] skip replicated jar resource: " + path));
                            continue;
                        }
                        ResourceRef ref = ResourceRef.toResourceRef((Resource)resource);
                        if (ref.getModifiers() != null) {
                            jarResources.add(ref);
                            if (!this.logger.isInfoEnabled()) continue;
                            this.logger.info((Object)("[jarFile] add jar resource: " + ref));
                            continue;
                        }
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("[jarFile] not rose jar resource: " + path));
                    }
                    catch (Exception e) {
                        this.logger.error((Object)urlObject, (Throwable)e);
                    }
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("[jarFile] not rose type(not a jar) " + urlObject));
            }
            this.jarResources = jarResources;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("[jarFile] found " + jarResources.size() + " jar files: " + jarResources));
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("[jarFile] found cached " + this.jarResources.size() + " jar files: " + this.jarResources));
        }
        return Collections.unmodifiableList(this.jarResources);
    }
}

