/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.expression.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.paoding.rose.jade.statement.expression.ExprResolver;
import net.paoding.rose.jade.statement.expression.ExqlPattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExqlUtils {
    private static final Log logger = LogFactory.getLog(ExqlPattern.class);

    public static Object execExpr(ExprResolver exprResolver, String expression) {
        try {
            return exprResolver.executeExpr(expression);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Can't resolving expression: " + expression), (Throwable)e);
            }
            return null;
        }
    }

    public static boolean isValid(Object obj) {
        return ExqlUtils.asBoolean(obj);
    }

    public static boolean asBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() > 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() > 0.0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() > 0;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) > 0;
        }
        return true;
    }

    public static Object[] asArray(Object obj) {
        if (obj == null) {
            return new Object[0];
        }
        if (obj.getClass().isArray()) {
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                Object[] array = new Object[length];
                for (int index = 0; index < length; ++index) {
                    array[index] = Array.get(obj, index);
                }
                return array;
            }
            return (Object[])obj;
        }
        return new Object[]{obj};
    }

    public static Collection<?> asCollection(Object obj) {
        if (obj == null) {
            return Collections.EMPTY_SET;
        }
        if (obj.getClass().isArray()) {
            return Arrays.asList(ExqlUtils.asArray(obj));
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet();
        }
        return Arrays.asList(obj);
    }
}

