/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.jade.statement.expression.impl;

import net.paoding.rose.jade.statement.expression.ExprResolver;
import net.paoding.rose.jade.statement.expression.ExqlContext;
import net.paoding.rose.jade.statement.expression.ExqlUnit;
import net.paoding.rose.jade.statement.expression.util.ExqlUtils;

public class ForEachUnit
implements ExqlUnit {
    private final String expr;
    private final String variant;
    private final ExqlUnit unit;

    public ForEachUnit(String expr, String variant, ExqlUnit unit) {
        this.expr = expr;
        this.variant = variant;
        this.unit = unit;
    }

    @Override
    public boolean isValid(ExprResolver exprResolver) {
        Object obj = ExqlUtils.execExpr(exprResolver, this.expr);
        if (ExqlUtils.isValid(obj)) {
            return this.unit.isValid(exprResolver);
        }
        return false;
    }

    @Override
    public void fill(ExqlContext exqlContext, ExprResolver exprResolver) throws Exception {
        Object obj = exprResolver.executeExpr(this.expr);
        if (this.variant == null) {
            for (Object value : ExqlUtils.asCollection(obj)) {
                exprResolver.setVar("_loop", value);
                this.unit.fill(exqlContext, exprResolver);
            }
        } else {
            Object variantValue = exprResolver.getVar(this.variant);
            for (Object value : ExqlUtils.asCollection(obj)) {
                exprResolver.setVar(this.variant, value);
                this.unit.fill(exqlContext, exprResolver);
            }
            exprResolver.setVar(this.variant, variantValue);
        }
    }
}

